package com.biz.crm.sfa.business.holiday.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.List;

/**
 * 节假日实体类
 *
 * @author ning.zhang
 * @date 2022/5/11
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "HolidayEntity", description = "节假日实体类")
@Entity
@TableName("sfa_holiday")
@Table(name = "sfa_holiday", indexes = {
    @Index(name = "sfa_holiday_index1", columnList = "year"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_holiday", comment = "节假日表")
public class HolidayEntity extends TenantFlagOpEntity {

  private static final long serialVersionUID = -6817815637270299076L;

  /**
   * 年份
   */
  @ApiModelProperty("年份")
  @Column(name = "year", length = 10, nullable = false, columnDefinition = "VARCHAR(10) NOT NULL COMMENT '年份'")
  private String year;

  /**
   * 法定节假日天数
   */
  @ApiModelProperty("法定节假日天数")
  @Column(name = "holiday_days", length = 5, nullable = false, columnDefinition = "INT(5) NOT NULL COMMENT '法定节假日天数'")
  private Integer holidayDays;

  /**
   * 计算薪资天数
   */
  @ApiModelProperty("计算薪资天数")
  @Column(name = "salary_days", length = 5, nullable = false, columnDefinition = "INT(5) NOT NULL COMMENT '计算薪资天数'")
  private Integer salaryDays;

  /**
   * 节假日日期信息
   */
  @ApiModelProperty("节假日日期信息")
  @Transient
  @TableField(exist = false)
  private List<HolidayDateEntity> dateList;
}
