package com.biz.crm.sfa.business.holiday.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.holiday.local.entity.HolidayEntity;
import com.biz.crm.sfa.business.holiday.sdk.dto.HolidayConditionDto;
import com.biz.crm.sfa.business.holiday.sdk.dto.HolidayPageDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 节假日表的mybatis-plus接口类 {@link HolidayEntity}
 *
 * @author ning.zhang
 * @date 2022-05-11 14:48:53
 */
public interface HolidayMapper extends BaseMapper<HolidayEntity> {

  /**
   * 通过节假日ID集合获取节假日信息
   *
   * @param ids 节假日ID集合
   * @return 节假日信息
   */
  List<HolidayEntity> findByIds(@Param("ids") List<String> ids);

  /**
   * 节假日分页列表
   *
   * @param dto  请求参数dto
   * @param page 分页信息
   * @return Page<HolidayEntity> 节假日分页信息
   */
  Page<HolidayEntity> findByConditions(Page<HolidayEntity> page, @Param("dto") HolidayPageDto dto);

  /**
   * 通过日期获取节假日信息
   *
   * @param date 日期
   * @return 节假日信息
   */
  List<HolidayEntity> findByDate(@Param("date") String date, @Param("tenantCode") String tenantCode);

  /**
   * 通过节假日条件获取节假日信息
   *
   * @param dto 参数dto
   * @return 节假日信息
   */
  List<HolidayEntity> findByHolidayConditionDto(@Param("dto") HolidayConditionDto dto);

}

