package com.biz.crm.sfa.business.holiday.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.sfa.business.holiday.local.entity.HolidayDateEntity;
import com.biz.crm.sfa.business.holiday.local.mapper.HolidayDateMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 节假日日期表的数据库访问类 {@link HolidayDateEntity}
 *
 * @author ning.zhang
 * @date 2022-05-11 14:49:53
 */
@Component
public class HolidayDateRepository extends ServiceImpl<HolidayDateMapper, HolidayDateEntity> {

  /**
   * 通过节假日ID删除节假日日期
   *
   * @param holidayId 节假日ID
   */
  public void deleteByHolidayId(String holidayId) {
    this.lambdaUpdate()
        .eq(HolidayDateEntity::getHolidayId, holidayId)
        .remove();
  }

  /**
   * 通过节假日ID集合获取节假日日期
   *
   * @param holidayIds 节假日ID集合
   * @return 节假日日期
   */
  public List<HolidayDateEntity> findByHolidayIds(List<String> holidayIds) {
    return this.lambdaQuery()
        .in(HolidayDateEntity::getHolidayId, holidayIds)
        .list();
  }
}
