package com.biz.crm.sfa.business.holiday.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.holiday.local.entity.HolidayEntity;
import com.biz.crm.sfa.business.holiday.sdk.dto.HolidayDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 节假日表服务接口
 *
 * @author ning.zhang
 * @date 2022-05-11 14:48:54
 */
public interface HolidayService {

  /**
   * 创建节假日
   *
   * @param dto 请求参数dto
   * @return 节假日实体
   */
  HolidayEntity create(HolidayDto dto);

  /**
   * 更新节假日
   *
   * @param dto 请求参数dto
   * @return 节假日实体
   */
  HolidayEntity update(HolidayDto dto);

  /**
   * 批量删除节假日
   *
   * @param ids 节假日id集合
   */
  void deleteBatch(List<String> ids);

  /**
   * 节假日分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<HolidayEntity> 节假日分页信息
   */
  Page<HolidayEntity> findByConditions(Pageable pageable, HolidayDto dto);
}
