/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.holiday.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.holiday.local.entity.HolidayEntity;
import com.biz.crm.sfa.business.holiday.local.service.HolidayService;
import com.biz.crm.sfa.business.holiday.sdk.dto.HolidayDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/holiday/holiday"})
@Api(tags={"\u8282\u5047\u65e5: Holiday: \u8282\u5047\u65e5\u914d\u7f6e"})
public class HolidayController {
    private static final Logger log = LoggerFactory.getLogger(HolidayController.class);
    @Autowired
    private HolidayService holidayService;

    @ApiOperation(value="\u65b0\u589e\u8282\u5047\u65e5")
    @PostMapping(value={""})
    public Result<HolidayEntity> create(@RequestBody HolidayDto dto) {
        try {
            return Result.ok((Object)((Object)this.holidayService.create(dto)));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u8282\u5047\u65e5\u4fe1\u606f")
    @PatchMapping(value={""})
    public Result<HolidayEntity> update(@RequestBody HolidayDto dto) {
        try {
            return Result.ok((Object)((Object)this.holidayService.update(dto)));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result deleteBatch(@RequestParam(value="ids") List<String> ids) {
        try {
            this.holidayService.deleteBatch(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

