/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.holiday.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.sfa.business.holiday.local.entity.HolidayDateEntity;
import com.biz.crm.sfa.business.holiday.local.entity.HolidayEntity;
import com.biz.crm.sfa.business.holiday.local.repository.HolidayRepository;
import com.biz.crm.sfa.business.holiday.local.service.HolidayDateService;
import com.biz.crm.sfa.business.holiday.local.service.HolidayService;
import com.biz.crm.sfa.business.holiday.sdk.dto.HolidayDto;
import com.biz.crm.sfa.business.holiday.sdk.event.HolidayEventListener;
import com.biz.crm.sfa.business.holiday.sdk.vo.HolidayVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="holidayService")
public class HolidayServiceImpl
implements HolidayService {
    private static final Logger log = LoggerFactory.getLogger(HolidayServiceImpl.class);
    @Autowired
    private HolidayRepository holidayRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private HolidayDateService holidayDateService;
    @Autowired(required=false)
    private List<HolidayEventListener> listeners;

    @Override
    @Transactional
    public HolidayEntity create(HolidayDto dto) {
        this.createValidation(dto);
        HolidayEntity entity = (HolidayEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, HolidayEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.holidayRepository.save((Object)entity);
        dto.setId(entity.getId());
        List<HolidayDateEntity> dateEntities = this.holidayDateService.update(dto);
        entity.setDateList(dateEntities);
        entity.setHolidayDays(dto.getHolidayDays());
        entity.setSalaryDays(dto.getSalaryDays());
        this.holidayRepository.updateById((Object)entity);
        if (!CollectionUtils.isEmpty(this.listeners)) {
            HolidayVo vo = (HolidayVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, HolidayVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.listeners.forEach(listener -> listener.onCreate(vo));
        }
        return entity;
    }

    @Override
    @Transactional
    public HolidayEntity update(HolidayDto dto) {
        this.updateValidation(dto);
        List<HolidayEntity> entities = this.holidayRepository.findByIds(Lists.newArrayList((Object[])new String[]{dto.getId()}));
        Validate.isTrue((!CollectionUtils.isEmpty(entities) ? 1 : 0) != 0, (String)"\u8282\u5047\u65e5\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        HolidayEntity updateEntity = (HolidayEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, HolidayEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.holidayRepository.updateById((Object)updateEntity);
        List<HolidayDateEntity> dateEntities = this.holidayDateService.update(dto);
        updateEntity.setDateList(dateEntities);
        updateEntity.setHolidayDays(dto.getHolidayDays());
        updateEntity.setSalaryDays(dto.getSalaryDays());
        this.holidayRepository.updateById((Object)updateEntity);
        if (!CollectionUtils.isEmpty(this.listeners)) {
            HolidayVo oldVo = (HolidayVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entities.get(0), HolidayVo.class, HashSet.class, ArrayList.class, new String[0]);
            HolidayVo newVo = (HolidayVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)updateEntity, HolidayVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.listeners.forEach(listener -> listener.onUpdate(oldVo, newVo));
        }
        return updateEntity;
    }

    @Override
    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u7f3a\u5931id", (Object[])new Object[0]);
        List entities = this.holidayRepository.listByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)entities) && entities.size() == ids.size() ? 1 : 0) != 0, (String)"\u6570\u636e\u5220\u9664\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
        this.holidayRepository.updateDelFlagByIds(ids);
        if (!CollectionUtils.isEmpty(this.listeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, HolidayEntity.class, HolidayVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.listeners.forEach(listener -> listener.onDelete(voList));
        }
    }

    @Override
    public Page<HolidayEntity> findByConditions(Pageable pageable, HolidayDto dto) {
        return null;
    }

    private void createValidation(HolidayDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setId(null);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setSalaryDays(Integer.valueOf(0));
        dto.setHolidayDays(Integer.valueOf(0));
        Validate.notBlank((CharSequence)dto.getYear(), (String)"\u7f3a\u5931\u5e74\u4efd", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getInfoList()) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u8282\u5047\u65e5\u660e\u7ec6\u4fe1\u606f", (Object[])new Object[0]);
        try {
            LocalDate.parse(String.format("%s-01-01", dto.getYear()), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u975e\u6cd5\u7684\u5e74\u4efd\u683c\u5f0f\uff0c\u53ef\u7528\u7684\u683c\u5f0f\uff1a[yyyy]", e);
        }
        HolidayEntity holidayEntity = this.holidayRepository.findByYear(dto.getYear(), dto.getYear());
        Validate.isTrue((boolean)Objects.isNull((Object)holidayEntity), (String)"\u5df2\u5b58\u5728\u76f8\u540c\u5e74\u4efd\u7684\u8282\u5047\u65e5\u4fe1\u606f", (Object[])new Object[0]);
    }

    private void updateValidation(HolidayDto dto) {
        Validate.notNull((Object)dto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setSalaryDays(Integer.valueOf(0));
        dto.setHolidayDays(Integer.valueOf(0));
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getYear(), (String)"\u7f3a\u5931\u5e74\u4efd", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)dto.getInfoList()) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u8282\u5047\u65e5\u660e\u7ec6\u4fe1\u606f", (Object[])new Object[0]);
        try {
            LocalDate.parse(String.format("%s-01-01", dto.getYear()), DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u975e\u6cd5\u7684\u5e74\u4efd\u683c\u5f0f\uff0c\u53ef\u7528\u7684\u683c\u5f0f\uff1a[yyyy]", e);
        }
        HolidayEntity holidayEntity = this.holidayRepository.findByYear(dto.getYear(), dto.getYear());
        Validate.isTrue((Objects.isNull((Object)holidayEntity) || holidayEntity.getId().equals(dto.getId()) ? 1 : 0) != 0, (String)"\u5df2\u5b58\u5728\u76f8\u540c\u5e74\u4efd\u7684\u8282\u5047\u65e5\u4fe1\u606f", (Object[])new Object[0]);
    }
}

