/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.holiday.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.holiday.local.entity.HolidayDateEntity;
import com.biz.crm.sfa.business.holiday.local.entity.HolidayEntity;
import com.biz.crm.sfa.business.holiday.local.repository.HolidayRepository;
import com.biz.crm.sfa.business.holiday.sdk.dto.HolidayConditionDto;
import com.biz.crm.sfa.business.holiday.sdk.dto.HolidayPageDto;
import com.biz.crm.sfa.business.holiday.sdk.service.HolidayVoService;
import com.biz.crm.sfa.business.holiday.sdk.vo.HolidayDateVo;
import com.biz.crm.sfa.business.holiday.sdk.vo.HolidayInfoVo;
import com.biz.crm.sfa.business.holiday.sdk.vo.HolidayVo;
import com.bizunited.nebula.common.service.CopyObjectCallback;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class HolidayVoServiceImpl
implements HolidayVoService,
CopyObjectCallback<HolidayEntity, HolidayVo> {
    private static final Logger log = LoggerFactory.getLogger(HolidayVoServiceImpl.class);
    @Autowired
    private HolidayRepository holidayRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    public HolidayVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        List<HolidayEntity> entities = this.holidayRepository.findByIds(Lists.newArrayList((Object[])new String[]{id}));
        if (CollectionUtils.isEmpty(entities)) {
            return null;
        }
        return (HolidayVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entities.get(0), HolidayVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public Page<HolidayVo> findByConditions(Pageable pageable, HolidayPageDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = (HolidayPageDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new HolidayPageDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<HolidayEntity> entityPage = this.holidayRepository.findByConditions(pageable, dto);
        List entities = entityPage.getRecords();
        Page pageResult = new Page(entityPage.getCurrent(), entityPage.getSize(), entityPage.getTotal());
        if (!CollectionUtils.isEmpty((Collection)entities)) {
            pageResult.setRecords((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, HolidayEntity.class, HolidayVo.class, HashSet.class, ArrayList.class, new String[0]));
        }
        return pageResult;
    }

    public HolidayVo findByDate(String date) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return null;
        }
        List<HolidayEntity> holidayEntities = this.holidayRepository.findByDate(date, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(holidayEntities)) {
            return null;
        }
        return (HolidayVo)this.nebulaToolkitService.copyObjectByBlankList((Object)holidayEntities.get(0), HolidayVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<HolidayVo> findByHolidayConditionDto(HolidayConditionDto dto) {
        if (Objects.isNull(dto)) {
            return Lists.newLinkedList();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<HolidayEntity> entities = this.holidayRepository.findByHolidayConditionDto(dto);
        if (CollectionUtils.isEmpty(entities)) {
            return Lists.newLinkedList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(entities, HolidayEntity.class, HolidayVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<String> findYearList() {
        List<HolidayEntity> entityList = this.holidayRepository.findAll(TenantUtils.getTenantCode());
        List<String> yearList = entityList.stream().map(HolidayEntity::getYear).distinct().collect(Collectors.toList());
        return yearList;
    }

    public boolean validate(Class<?> sourceClass, Class<?> targetClass) {
        return HolidayEntity.class.isAssignableFrom(sourceClass) && HolidayVo.class.isAssignableFrom(targetClass);
    }

    public void callback(Class<HolidayEntity> sourceClass, List<HolidayEntity> sourceObjects, Class<HolidayVo> targetClass, List<HolidayVo> targetObjects) {
        for (int i = 0; i < sourceObjects.size(); ++i) {
            HolidayEntity holidayEntity = sourceObjects.get(i);
            HolidayVo holidayVo = targetObjects.get(i);
            List<HolidayDateEntity> dateList = holidayEntity.getDateList();
            HashMap holidayInfoMap = Maps.newHashMap();
            if (CollectionUtils.isEmpty(dateList)) continue;
            dateList.sort(Comparator.comparing(HolidayDateEntity::getHolidayDate));
            dateList.forEach(holidayDateEntity -> {
                HolidayInfoVo holidayInfoVo = holidayInfoMap.getOrDefault(holidayDateEntity.getHolidayId(), new HolidayInfoVo());
                if (CollectionUtils.isEmpty((Collection)holidayInfoVo.getDateList())) {
                    holidayInfoVo.setDateList((List)Lists.newArrayList());
                    holidayInfoVo.setStartDate(holidayDateEntity.getHolidayDate());
                    holidayInfoVo.setEndDate(holidayDateEntity.getHolidayDate());
                    holidayInfoVo.setHolidayName(holidayDateEntity.getHolidayName());
                }
                HolidayDateVo holidayDateVo = new HolidayDateVo();
                holidayDateVo.setHolidayDate(holidayDateEntity.getHolidayDate());
                holidayDateVo.setCalculationSalary(holidayDateEntity.getCalculationSalary());
                holidayInfoVo.getDateList().add(holidayDateVo);
                holidayInfoVo.setStartDate(holidayInfoVo.getStartDate().compareTo(holidayDateEntity.getHolidayDate()) > 0 ? holidayDateEntity.getHolidayDate() : holidayInfoVo.getStartDate());
                holidayInfoVo.setEndDate(holidayInfoVo.getEndDate().compareTo(holidayDateEntity.getHolidayDate()) < 0 ? holidayDateEntity.getHolidayDate() : holidayInfoVo.getStartDate());
                holidayInfoMap.put(holidayDateEntity.getHolidayId(), holidayInfoVo);
            });
            holidayVo.setInfoList((List)Lists.newArrayList(holidayInfoMap.values()));
        }
    }
}

