/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.holiday.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.holiday.sdk.dto.HolidayPageDto;
import com.biz.crm.sfa.business.holiday.sdk.service.HolidayVoService;
import com.biz.crm.sfa.business.holiday.sdk.vo.HolidayVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/holiday/holiday"})
@Api(tags={"\u8282\u5047\u65e5: HolidayVo: \u8282\u5047\u65e5\u914d\u7f6e"})
public class HolidayVoController {
    private static final Logger log = LoggerFactory.getLogger(HolidayVoController.class);
    @Autowired
    private HolidayVoService holidayVoService;

    @ApiOperation(value="\u901a\u8fc7ID\u83b7\u53d6\u8282\u5047\u65e5\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/findById"})
    public Result<HolidayVo> findById(@RequestParam(value="id", required=false) @ApiParam(name="id", value="\u4e3b\u952eID") String id) {
        try {
            return Result.ok((Object)this.holidayVoService.findById(id));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8282\u5047\u65e5\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<HolidayVo>> findByConditions(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="HolidayPageDto", value="\u5206\u9875Dto") HolidayPageDto dto) {
        try {
            return Result.ok((Object)this.holidayVoService.findByConditions(pageable, dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u5e74\u4efd\u5217\u8868")
    @GetMapping(value={"/findYearList"})
    public Result<List<String>> findYearList() {
        Result result = new Result();
        List yearList = this.holidayVoService.findYearList();
        result.setResult((Object)yearList);
        return result;
    }
}

