/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.holiday.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.sfa.business.holiday.local.entity.HolidayEntity;
import com.biz.crm.sfa.business.holiday.local.mapper.HolidayMapper;
import com.biz.crm.sfa.business.holiday.sdk.dto.HolidayConditionDto;
import com.biz.crm.sfa.business.holiday.sdk.dto.HolidayPageDto;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class HolidayRepository
extends ServiceImpl<HolidayMapper, HolidayEntity> {
    public List<HolidayEntity> findByIds(List<String> ids) {
        return ((HolidayMapper)this.baseMapper).findByIds(ids);
    }

    public HolidayEntity findByYear(String year, String tenantCode) {
        return (HolidayEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(HolidayEntity::getYear, (Object)year)).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).one());
    }

    public List<HolidayEntity> findByDate(String date, String tenantCode) {
        return ((HolidayMapper)this.baseMapper).findByDate(date, tenantCode);
    }

    public List<HolidayEntity> findByHolidayConditionDto(HolidayConditionDto dto) {
        return ((HolidayMapper)this.baseMapper).findByHolidayConditionDto(dto);
    }

    public void updateDelFlagByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public Page<HolidayEntity> findByConditions(Pageable pageable, HolidayPageDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((HolidayMapper)this.baseMapper).findByConditions((Page<HolidayEntity>)page, dto);
    }

    public List<HolidayEntity> findAll(String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).orderByAsc(HolidayEntity::getYear)).list();
    }
}

