/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.holiday.local.service.internal;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.sfa.business.holiday.local.entity.HolidayDateEntity;
import com.biz.crm.sfa.business.holiday.local.entity.HolidayEntity;
import com.biz.crm.sfa.business.holiday.local.repository.HolidayDateRepository;
import com.biz.crm.sfa.business.holiday.local.repository.HolidayRepository;
import com.biz.crm.sfa.business.holiday.local.service.HolidayDateService;
import com.biz.crm.sfa.business.holiday.sdk.dto.HolidayConditionDto;
import com.biz.crm.sfa.business.holiday.sdk.dto.HolidayDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="holidayDateService")
public class HolidayDateServiceImpl
implements HolidayDateService {
    private static final Logger log = LoggerFactory.getLogger(HolidayDateServiceImpl.class);
    @Autowired
    private HolidayDateRepository holidayDateRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private HolidayRepository holidayRepository;

    @Override
    @Transactional
    public List<HolidayDateEntity> update(HolidayDto dto) {
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u8282\u5047\u65e5ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.holidayDateRepository.deleteByHolidayId(dto.getId());
        this.updateValidation(dto);
        ArrayList entities = Lists.newArrayList();
        dto.getInfoList().forEach(holidayInfoDto -> holidayInfoDto.getDateList().forEach(holidayDateDto -> {
            HolidayDateEntity entity = (HolidayDateEntity)((Object)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(holidayDateDto, HolidayDateEntity.class, HashSet.class, ArrayList.class, new String[0]))));
            entity.setHolidayId(dto.getId());
            entity.setHolidayName(holidayInfoDto.getHolidayName());
            entities.add(entity);
        }));
        this.holidayDateRepository.saveBatch(entities);
        return entities;
    }

    private void updateValidation(HolidayDto dto) {
        HashSet holidayDates = Sets.newHashSet();
        dto.getInfoList().forEach(holidayInfoDto -> {
            Validate.notBlank((CharSequence)holidayInfoDto.getHolidayName(), (String)"\u7f3a\u5931\u8282\u5047\u65e5\u540d\u79f0", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)holidayInfoDto.getEndDate(), (String)String.format("\u8282\u65e5[%s],\u7f3a\u5931\u7ed3\u675f\u65e5\u671f", holidayInfoDto.getHolidayName()), (Object[])new Object[0]);
            Validate.notBlank((CharSequence)holidayInfoDto.getStartDate(), (String)String.format("\u8282\u65e5[%s],\u7f3a\u5931\u5f00\u59cb\u65e5\u671f", holidayInfoDto.getHolidayName()), (Object[])new Object[0]);
            LocalDate endDate = this.parseDateFormat(holidayInfoDto.getEndDate());
            LocalDate startDate = this.parseDateFormat(holidayInfoDto.getStartDate());
            Validate.notNull((Object)endDate, (String)String.format("\u8282\u65e5[%s],\u5b58\u5728\u975e\u6cd5\u7684\u7ed3\u675f\u65e5\u671f\u683c\u5f0f\uff0c\u53ef\u7528\u7684\u683c\u5f0f\uff1a[yyyy-MM-dd]", holidayInfoDto.getHolidayName()), (Object[])new Object[0]);
            Validate.notNull((Object)startDate, (String)String.format("\u8282\u65e5[%s],\u5b58\u5728\u975e\u6cd5\u7684\u5f00\u59cb\u65e5\u671f\u683c\u5f0f\uff0c\u53ef\u7528\u7684\u683c\u5f0f\uff1a[yyyy-MM-dd]", holidayInfoDto.getHolidayName()), (Object[])new Object[0]);
            Validate.isTrue((boolean)holidayInfoDto.getStartDate().substring(0, 4).equals(dto.getYear()), (String)String.format("\u8282\u65e5[%s],\u5f00\u59cb\u65e5\u671f\u4e0d\u5728\u6240\u9009\u5e74\u4efd\u5185", holidayInfoDto.getHolidayName()), (Object[])new Object[0]);
            Validate.isTrue((boolean)holidayInfoDto.getEndDate().substring(0, 4).equals(dto.getYear()), (String)String.format("\u8282\u65e5[%s],\u7ed3\u675f\u65e5\u671f\u4e0d\u5728\u6240\u9009\u5e74\u4efd\u5185", holidayInfoDto.getHolidayName()), (Object[])new Object[0]);
            Validate.isTrue((holidayInfoDto.getEndDate().compareTo(holidayInfoDto.getStartDate()) >= 0 ? 1 : 0) != 0, (String)String.format("\u8282\u65e5[%s],\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f", holidayInfoDto.getHolidayName()), (Object[])new Object[0]);
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)holidayInfoDto.getDateList()) ? 1 : 0) != 0, (String)"\u7f3a\u5931\u8282\u5047\u65e5\u65e5\u671f\u4fe1\u606f", (Object[])new Object[0]);
            HashMap holidayDateMap = Maps.newHashMap();
            holidayInfoDto.getDateList().forEach(holidayDateDto -> {
                holidayDateDto.setId(null);
                Validate.notBlank((CharSequence)holidayDateDto.getHolidayDate(), (String)String.format("\u8282\u65e5[%s],\u7f3a\u5931\u8282\u65e5\u65e5\u671f", holidayInfoDto.getHolidayName()), (Object[])new Object[0]);
                Validate.notBlank((CharSequence)holidayDateDto.getCalculationSalary(), (String)String.format("\u8282\u65e5[%s],\u7f3a\u5931\u662f\u5426\u8ba1\u7b97\u85aa\u8d44", holidayInfoDto.getHolidayName()), (Object[])new Object[0]);
                Validate.notNull((Object)this.parseDateFormat(holidayDateDto.getHolidayDate()), (String)String.format("\u8282\u65e5[%s],\u5b58\u5728\u975e\u6cd5\u7684\u8282\u65e5\u65e5\u671f\u683c\u5f0f\uff0c\u53ef\u7528\u7684\u683c\u5f0f\uff1a[yyyy-MM-dd]", holidayInfoDto.getHolidayName()), (Object[])new Object[0]);
                Validate.isTrue((holidayInfoDto.getStartDate().compareTo(holidayDateDto.getHolidayDate()) <= 0 && holidayInfoDto.getEndDate().compareTo(holidayDateDto.getHolidayDate()) >= 0 ? 1 : 0) != 0, (String)String.format("\u8282\u65e5[%s],\u65e5\u671f[%s]\u4e0d\u5728\u6240\u9009\u8303\u56f4\u5185", holidayInfoDto.getHolidayName(), holidayDateDto.getHolidayDate()), (Object[])new Object[0]);
                Validate.isTrue((boolean)Objects.isNull(holidayDateMap.get(holidayDateDto.getHolidayDate())), (String)String.format("\u8282\u65e5[%s],\u5b58\u5728\u91cd\u590d\u7684\u8282\u65e5\u65e5\u671f[%s]", holidayInfoDto.getHolidayName(), holidayDateDto.getHolidayDate()), (Object[])new Object[0]);
                dto.setSalaryDays(Integer.valueOf(dto.getSalaryDays() + (BooleanEnum.TRUE.getCapital().equals(holidayDateDto.getCalculationSalary()) ? 1 : 0)));
                dto.setHolidayDays(Integer.valueOf(dto.getHolidayDays() + 1));
                holidayDateMap.put(holidayDateDto.getHolidayDate(), holidayDateDto);
            });
            holidayDates.addAll(holidayDateMap.keySet());
        });
        HolidayConditionDto conditionDto = new HolidayConditionDto();
        conditionDto.setTenantCode(TenantUtils.getTenantCode());
        conditionDto.setDates((Set)holidayDates);
        List<HolidayEntity> holidayEntities = this.holidayRepository.findByHolidayConditionDto(conditionDto);
        if (!CollectionUtils.isEmpty(holidayEntities)) {
            throw new IllegalArgumentException(String.format("\u8282\u65e5\u65e5\u671f[%s]\u5df2\u5b58\u5728", holidayEntities.get(0).getDateList().get(0).getHolidayDate()));
        }
    }

    private LocalDate parseDateFormat(String dateStr) {
        LocalDate result;
        try {
            result = LocalDate.parse(dateStr, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }
}

