package com.biz.crm.sfa.business.holiday.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Set;

/**
 * 节假日条件查询Dto
 *
 * @author ning.zhang
 * @date 2022/5/5
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "HolidayConditionDto", description = "节假日条件查询Dto")
public class HolidayConditionDto extends TenantDto {

  /**
   * 年份
   */
  @ApiModelProperty("年份")
  private Set<String> years;

  /**
   * 日期
   */
  @ApiModelProperty("日期")
  private Set<String> dates;
}
