package com.biz.crm.sfa.business.holiday.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 节假日日期Dto
 *
 * @author ning.zhang
 * @date 2022/5/11
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "HolidayDateDto", description = "节假日日期Dto")
public class HolidayDateDto extends TenantDto {

  /**
   * 节日日期
   */
  @ApiModelProperty("节日日期")
  private String holidayDate;

  /**
   * 是否计算薪资(Y:是;N:否)
   * @see com.biz.crm.business.common.sdk.enums.BooleanEnum
   */
  @ApiModelProperty("是否计算薪资(Y:是;N:否)")
  private String calculationSalary;
}
