package com.biz.crm.sfa.business.holiday.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 节假日Dto
 *
 * @author ning.zhang
 * @date 2022/5/11
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "HolidayDto", description = "节假日Dto")
public class HolidayDto extends TenantDto {

  /**
   * 年份
   */
  @ApiModelProperty("年份")
  private String year;

  /**
   * 法定节假日天数
   */
  @ApiModelProperty(value = "法定节假日天数", hidden = true)
  private Integer holidayDays;

  /**
   * 计算薪资天数
   */
  @ApiModelProperty(value = "计算薪资天数", hidden = true)
  private Integer salaryDays;

  /**
   * 节假日明细信息
   */
  @ApiModelProperty("节假日明细信息")
  private List<HolidayInfoDto> infoList;
}
