package com.biz.crm.sfa.business.holiday.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 节假日明细Dto
 *
 * @author ning.zhang
 * @date 2022/5/11
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "HolidayInfoDto", description = "节假日明细Dto")
public class HolidayInfoDto extends TenantDto {

  /**
   * 节假日名称
   */
  @ApiModelProperty("节假日名称")
  private String holidayName;

  /**
   * 开始日期
   */
  @ApiModelProperty("开始日期")
  private String startDate;

  /**
   * 结束日期
   */
  @ApiModelProperty("结束日期")
  private String endDate;

  /**
   * 节假日日期信息
   */
  @ApiModelProperty("节假日日期信息")
  private List<HolidayDateDto> dateList;
}
