package com.biz.crm.sfa.business.holiday.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 节假日分页Dto
 *
 * @author ning.zhang
 * @date 2022/5/5
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "HolidayPageDto", description = "节假日分页Dto")
public class HolidayPageDto extends TenantDto {

  /**
   * 年份
   */
  @ApiModelProperty("年份")
  private String year;

  /**
   * 创建人名称
   */
  @ApiModelProperty("创建人名称")
  private String createName;

  /**
   * 创建时间
   */
  @ApiModelProperty("创建时间")
  private String createTime;
}
