package com.biz.crm.sfa.business.holiday.sdk.event;

import com.biz.crm.sfa.business.holiday.sdk.vo.HolidayVo;

import java.util.List;

/**
 * 节假日事件通知
 *
 * @author ning.zhang
 * @date 2022/5/13
 */
public interface HolidayEventListener {

  /**
   * 当节假日新增时触发
   *
   * @param vo 节假日信息
   */
  void onCreate(HolidayVo vo);

  /**
   * 当节假日修改时触发
   *
   * @param oldVo 修改之前的vo
   * @param newVo 修改之后的vo
   */
  void onUpdate(HolidayVo oldVo, HolidayVo newVo);

  /**
   * 当节假日删除时触发
   *
   * @param voList 删除vo信息
   */
  void onDelete(List<HolidayVo> voList);
}
