package com.biz.crm.sfa.business.holiday.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.holiday.sdk.dto.HolidayConditionDto;
import com.biz.crm.sfa.business.holiday.sdk.dto.HolidayPageDto;
import com.biz.crm.sfa.business.holiday.sdk.vo.HolidayVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 节假日Vo服务接口类
 *
 * @author ning.zhang
 * @date 2022/5/11
 */
public interface HolidayVoService {

  /**
   * 通过节假日ID获取节假日信息
   *
   * @param id 节假日ID
   * @return 节假日信息
   */
  HolidayVo findById(String id);

  /**
   * 节假日分页列表
   *
   * @param dto      请求参数dto
   * @param pageable 分页信息
   * @return Page<HolidayVo> 节假日分页信息
   */
  Page<HolidayVo> findByConditions(Pageable pageable, HolidayPageDto dto);

  /**
   * 通过日期获取节假日信息
   *
   * @param date 日期
   * @return 节假日信息
   */
  HolidayVo findByDate(String date);

  /**
   * 通过节假日条件获取节假日信息
   *
   * @param dto 参数dto
   * @return 节假日信息
   */
  List<HolidayVo> findByHolidayConditionDto(HolidayConditionDto dto);

  /**
   * 查询年份列表
   * @return
   */
  List<String> findYearList();
}
