package com.biz.crm.sfa.business.holiday.sdk.vo;

import com.biz.crm.business.common.sdk.vo.UuidOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 节假日日期Vo
 *
 * @author ning.zhang
 * @date 2022/5/11
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "HolidayVo", description = "节假日日期Vo")
public class HolidayDateVo extends UuidOpVo {

  private static final long serialVersionUID = 4494095821863463988L;

  /**
   * 节日日期
   */
  @ApiModelProperty("节日日期")
  private String holidayDate;

  /**
   * 是否计算薪资(Y:是;N:否)
   * @see com.biz.crm.business.common.sdk.enums.BooleanEnum
   */
  @ApiModelProperty("是否计算薪资(Y:是;N:否)")
  private String calculationSalary;
}
