package com.biz.crm.sfa.business.holiday.sdk.vo;

import com.biz.crm.business.common.sdk.vo.UuidOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 节假日明细Vo
 *
 * @author ning.zhang
 * @date 2022/5/11
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "HolidayInfoVo", description = "节假日明细Vo")
public class HolidayInfoVo extends UuidOpVo {

  private static final long serialVersionUID = 4201091999659959943L;
  /**
   * 节假日名称
   */
  @ApiModelProperty("节假日名称")
  private String holidayName;

  /**
   * 开始日期
   */
  @ApiModelProperty("开始日期")
  private String startDate;

  /**
   * 结束日期
   */
  @ApiModelProperty("结束日期")
  private String endDate;

  /**
   * 节假日明细信息
   */
  @ApiModelProperty("节假日明细信息")
  private List<HolidayDateVo> dateList;
}
