package com.biz.crm.sfa.business.holiday.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 节假日Vo
 *
 * @author ning.zhang
 * @date 2022/5/11
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "HolidayVo", description = "节假日Vo")
public class HolidayVo extends TenantFlagOpVo {

  private static final long serialVersionUID = 4867291151631120414L;

  /**
   * 年份
   */
  @ApiModelProperty("年份")
  private String year;

  /**
   * 法定节假日天数
   */
  @ApiModelProperty("法定节假日天数")
  private Integer holidayDays;

  /**
   * 计算薪资天数
   */
  @ApiModelProperty("计算薪资天数")
  private Integer salaryDays;

  /**
   * 节假日明细信息
   */
  @ApiModelProperty("节假日明细信息")
  private List<HolidayInfoVo> infoList;
}
