package com.biz.crm.sfa.business.integral.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.integral.local.entity.Integral;
import com.biz.crm.sfa.business.integral.local.service.IntegralReportService;
import com.biz.crm.sfa.business.integral.sdk.dto.IntegralCountDto;
import com.biz.crm.sfa.business.integral.sdk.vo.IntegralCountVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @description: 积分报表
 * @author: rentao
 * @date: 2022/6/27 10:08
 */
@RestController
@RequestMapping("/v1/integral/integralReport")
@Slf4j
@Api(tags = "积分报表:IntegralReport:积分报表")
public class IntegralReportController {

  @Autowired
  private IntegralReportService integralReportService;

  /**
   * 积分排名（后台报表）
   *
   * @param pageable 分页对象
   * @param integralCountDto 查询实体
   * @return 所有数据
   */
  @ApiOperation(value = "积分排名（后台报表）")
  @GetMapping("findIntegralCountByConditions")
  public Result<Page<IntegralCountVo>> findIntegralCountByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
      @ApiParam(name = "IntegralCountDto", value = "积分统计dto") IntegralCountDto integralCountDto) {
    try {
      Page<IntegralCountVo> page =  this.integralReportService.findIntegralCountByConditions(pageable,integralCountDto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  /**
   * 积分排名（移动端报表）
   *
   * @param pageable 分页对象
   * @param integralCountDto 查询实体
   * @return 所有数据
   */
  @ApiOperation(value = "积分排名（移动端报表）")
  @GetMapping("findIntegralCountAppByConditions")
  public Result<Page<IntegralCountVo>> findIntegralCountAppByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
      @ApiParam(name = "IntegralCountDto", value = "积分统计dto") IntegralCountDto integralCountDto) {
    try {
      Page<IntegralCountVo> page =  this.integralReportService.findIntegralCountAppByConditions(pageable,integralCountDto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  /**
   * 查询登录人积分和排名
   *
   * @param rangType 分页对象 IntegralOrgTyepEnum
   * @return
   */
  @ApiOperation(value = "查询登录人积分和排名")
  @GetMapping("findByRangType")
  public Result<IntegralCountVo> findByRangType(@RequestParam("rangType") String rangType) {
    try {
      IntegralCountVo integralCountVo =  this.integralReportService.findByRangType(rangType);
      return Result.ok(integralCountVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
