package com.biz.crm.sfa.business.integral.local.listerner;

import cn.hutool.core.date.DateUtil;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.sfa.business.integral.local.entity.Integral;
import com.biz.crm.sfa.business.integral.local.service.IntegralService;
import com.biz.crm.sfa.business.integral.rule.sdk.service.IntegralRuleVoService;
import com.biz.crm.sfa.business.integral.rule.sdk.vo.IntegralCalculateRuleVo;
import com.biz.crm.sfa.business.integral.rule.sdk.vo.IntegralRuleVo;
import com.biz.crm.sfa.business.step.sdk.listerner.StepFormIntegralListener;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * @description: 步骤表单加积分
 * @author: rentao
 * @date: 2022/6/29 14:24
 */
@Component
public class StepFormIntegralListenerImpl implements StepFormIntegralListener {

  @Autowired private IntegralRuleVoService integralRuleVoService;
  @Autowired private IntegralService integralService;
  @Autowired private UserFeignVoService userFeignVoService;
  @Autowired private LoginUserService loginUserService;
  /**
   * 触发获取积分
   *
   * @param parentCode 上层业务编码，所实现模块的业务编码
   * @param dynamicKey 当前关联的动态key，即步骤编码
   * @param dynamicFormCode 表单编码
   */
  @Override
  public void onCreateIntegral(String parentCode, String dynamicKey, String dynamicFormCode) {
    // 获取登录人积分规则
    IntegralRuleVo integralRuleVo = this.integralRuleVoService.findByLoginUser();
    if (Objects.isNull(integralRuleVo)) {
      return;
    }
    List<IntegralCalculateRuleVo> integralCalculateRuleVos =
        integralRuleVo.getIntegralCalculateRuleVos();
    if (CollectionUtils.isEmpty(integralCalculateRuleVos)) {
      return;
    }
    List<IntegralCalculateRuleVo> calculateRuleVoList =
        integralCalculateRuleVos.stream()
            .filter(
                integralCalculateRuleVo ->
                integralCalculateRuleVo.getIntegralTaskTypeCode().equals(dynamicKey))
            .collect(Collectors.toList());
    if(CollectionUtils.isEmpty(calculateRuleVoList)){
      return;
    }
    // 步骤需要加多少积分
    Integral integral =
        this.assemblyIntegral(parentCode, dynamicKey, dynamicFormCode, calculateRuleVoList, integralRuleVo);
    // 加积分
    integralService.create(integral);
  }

  /**
   * 组装
   *
   * @param parentCode
   * @param dynamicKey
   * @param dynamicFormCode
   * @param calculateRuleVoList
   * @param integralRuleVo
   * @author rentao
   * @date a
   */
  private Integral assemblyIntegral(
      String parentCode,
      String dynamicKey,
      String dynamicFormCode,
      List<IntegralCalculateRuleVo> calculateRuleVoList,
      IntegralRuleVo integralRuleVo) {
    LoginUserDetails loginDetails = this.loginUserService.getLoginDetails(LoginUserDetails.class);
    IntegralCalculateRuleVo integralCalculateRuleVo = calculateRuleVoList.get(0);
    Integer integralTaskReward = integralCalculateRuleVo.getIntegralTaskReward();
    Integral integral = new Integral();
    integral.setParentCode(parentCode);
    integral.setDynamicKey(dynamicKey);
    integral.setDynamicFormCode(dynamicFormCode);
    integral.setIntegralRuleId(integralRuleVo.getId());
    integral.setIntegralRuleCode(integralRuleVo.getIntegralRuleCode());
    integral.setIntegralRuleName(integralRuleVo.getIntegralRuleName());
    integral.setIntegralYearMonth(DateUtil.format(new Date(), "yyyy-MM"));
    integral.setIntegralNum(integralTaskReward);
    integral.setIntegralTaskTypeCode(integralCalculateRuleVo.getIntegralTaskTypeCode());
    integral.setIntegralTaskTypeName(integralCalculateRuleVo.getIntegralTaskTypeName());
    // 创建人组织 岗位 岗位级别
    List<UserVo> userVos =
        userFeignVoService.findByUserNames(Collections.singletonList(loginDetails.getAccount()));
    if (!CollectionUtils.isEmpty(userVos)) {
      UserVo userVo = userVos.get(0);
      integral.setCreateOrgCode(userVo.getOrgCode());
      integral.setCreateOrgName(userVo.getOrgName());
      integral.setCreatePosCode(userVo.getPositionCode());
      integral.setCreatePosName(userVo.getPositionName());
      integral.setCreatePositionLevelCode(userVo.getPositionLevelCode());
      integral.setCreatePositionLevelName(userVo.getPositionLevelName());
    }
    return integral;
  }
}
