package com.biz.crm.sfa.business.integral.local.service.internal;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.sfa.business.integral.local.enums.IntegralOrgTyepEnum;
import com.biz.crm.sfa.business.integral.local.repository.IntegralRepository;
import com.biz.crm.sfa.business.integral.local.service.IntegralReportService;
import com.biz.crm.sfa.business.integral.sdk.dto.IntegralCountDto;
import com.biz.crm.sfa.business.integral.sdk.vo.IntegralCountVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/**
 * @description: 积分报表
 * @author: rentao
 * @date: 2022/6/27 14:54
 */
@Service
@Slf4j
public class IntegralReportServiceImpl implements IntegralReportService {

  @Autowired private IntegralRepository integralRepository;
  @Autowired private UserFeignVoService userFeignVoService;
  @Autowired private LoginUserService loginUserService;
  @Autowired private OrgVoService orgVoService;

  /**
   * 积分排名分页接口
   *
   * @param pageable
   * @param integralCountDto
   * @author rentao
   * @date a
   */
  @Override
  public Page<IntegralCountVo> findIntegralCountByConditions(
      Pageable pageable, IntegralCountDto integralCountDto) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (Objects.isNull(integralCountDto)) {
      integralCountDto = new IntegralCountDto();
    }
    integralCountDto.setTenantCode(TenantUtils.getTenantCode());
    Page<IntegralCountVo> integralCountVoPage =
        this.integralRepository.findIntegralCountByConditions(pageable, integralCountDto);
    // todo  需要讨论换岗换组织换职位等级情况   拼接组织名称职位名称职位级别
    this.assemblyIntegralCountVo(integralCountVoPage.getRecords());
    return integralCountVoPage;
  }

  @Override
  public IntegralCountVo findByRangType(String rangType) {
    LoginUserDetails loginDetails = loginUserService.getLoginDetails(LoginUserDetails.class);
    String orgCode = loginDetails.getOrgCode();
    IntegralCountDto integralCountDto = new IntegralCountDto();
    integralCountDto.setIntegralYearMonth(DateUtil.format(new Date(), "yyyy-MM"));
    integralCountDto.setTenantCode(TenantUtils.getTenantCode());
    integralCountDto.setCreateAccount(loginDetails.getAccount());
    // 封装查询条件
    integralCountDto = this.getSearchVo(orgCode, integralCountDto, rangType);

    return integralRepository.findIntegralCountByCreateAccount(integralCountDto);
  }

  @Override
  public Page<IntegralCountVo> findIntegralCountAppByConditions(
      Pageable pageable, IntegralCountDto integralCountDto) {
    LoginUserDetails loginDetails = loginUserService.getLoginDetails(LoginUserDetails.class);
    String orgCode = loginDetails.getOrgCode();
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (Objects.isNull(integralCountDto)) {
      integralCountDto = new IntegralCountDto();
    }
    integralCountDto.setIntegralYearMonth(DateUtil.format(new Date(), "yyyy-MM"));
    integralCountDto.setTenantCode(TenantUtils.getTenantCode());
    integralCountDto = this.getSearchVo(orgCode, integralCountDto, integralCountDto.getRangType());
    Page<IntegralCountVo> integralCountVoPage = this.integralRepository.findIntegralCountByConditions(pageable, integralCountDto);
    this.assemblyIntegralCountVo(integralCountVoPage.getRecords());
    return integralCountVoPage;
  }

  /**
   * 拼接 组织名称 职位名称 职位级别
   *
   * @param integralCountVoList
   * @author rentao
   * @date a
   */
  private void assemblyIntegralCountVo(List<IntegralCountVo> integralCountVoList) {
    if (!CollectionUtils.isEmpty(integralCountVoList)) {
      // 账号
      List<String> accouts =
          integralCountVoList.stream()
              .map(IntegralCountVo::getCreateAccount)
              .collect(Collectors.toList());
      List<UserVo> userVos = userFeignVoService.findByUserNames(accouts);
      if (!CollectionUtils.isEmpty(userVos)) {
        Map<String, UserVo> userVoMap =
            userVos.stream().collect(Collectors.toMap(UserVo::getUserName, o -> o));
        integralCountVoList.forEach(
            integralCountVo -> {
              UserVo userVo = userVoMap.get(integralCountVo.getCreateAccount());
              integralCountVo.setCreateOrgCode(userVo.getOrgCode());
              integralCountVo.setCreateOrgName(userVo.getOrgName());
              integralCountVo.setCreatePosCode(userVo.getPositionCode());
              integralCountVo.setCreatePosName(userVo.getPositionName());
              integralCountVo.setCreatePositionLevelCode(userVo.getPositionLevelCode());
              integralCountVo.setCreatePositionLevelName(userVo.getPositionLevelName());
            });
      }
    }
  }

  /**
   * 封装需要查询的组织范围
   *
   * @method getSearchVo
   * @date: 2021/1/15 15:37
   * @author: YuanZiJian
   * @param userOrgCode
   * @param integralCountDto
   * @param orgRange
   * @return com.biz.crm.nebular.sfa.integral.req.SfaIntegralRankReqVo
   */
  private IntegralCountDto getSearchVo(
      String userOrgCode, IntegralCountDto integralCountDto, String orgRange) {
    // 封装查条件——本部门
    if (IntegralOrgTyepEnum.NOW_ORG.getDictCode().equals(orgRange)) {
      List<String> orgCodeList = new ArrayList<>();
      orgCodeList.add(userOrgCode);
      integralCountDto.setOrgCodeList(orgCodeList);
    }
    // 封装查条件——本公司
    if (IntegralOrgTyepEnum.ALL_ORG.getDictCode().equals(orgRange)
        || StringUtils.isBlank(orgRange)) {
      List<OrgVo> allParentByOrgCode = orgVoService.findAllParentByOrgCode(userOrgCode);
      Validate.isTrue(!CollectionUtils.isEmpty(allParentByOrgCode), "当前登录人组织数据有误！");
      List<OrgVo> orgVos =
          allParentByOrgCode.stream()
              .filter(orgVo -> StringUtils.isBlank(orgVo.getParentCode()))
              .collect(Collectors.toList());
      if (CollectionUtils.isEmpty(orgVos)) {
        integralCountDto.setOrgCodeList(Collections.singletonList(userOrgCode));
      } else {
        List<OrgVo> allChildrenOrg =
            this.orgVoService.findAllChildrenByOrgCode(orgVos.get(0).getOrgCode());
        List<String> orgCodes =
            allChildrenOrg.stream().map(OrgVo::getOrgCode).collect(Collectors.toList());
        integralCountDto.setOrgCodeList(orgCodes);
      }
    }
    // 封装查条件——当前组织及下级组织
    if (IntegralOrgTyepEnum.AFTER_ORG.getDictCode().equals(orgRange)) {
      List<OrgVo> allChildrenOrg = this.orgVoService.findAllChildrenByOrgCode(userOrgCode);
      List<String> allChildrenOrgList =
          allChildrenOrg.stream().map(OrgVo::getOrgCode).collect(Collectors.toList());
      integralCountDto.setOrgCodeList(allChildrenOrgList);
    }
    return integralCountDto;
  }
}
