package com.biz.crm.sfa.business.integral.local.service.internal;

import com.biz.crm.sfa.business.integral.local.repository.IntegralRepository;
import com.biz.crm.sfa.business.integral.local.entity.Integral;
import com.biz.crm.sfa.business.integral.local.service.IntegralService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.stereotype.Service;
import org.springframework.beans.factory.annotation.Autowired;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;

import java.util.List;
import java.util.Objects;

/**
 * 积分表(Integral)表服务实现类
 *
 * @author rentao
 * @since 2022-06-25 10:14:50
 */
@Service("integralService")
public class IntegralServiceImpl implements IntegralService {

  @Autowired private IntegralRepository integralRepository;

  /**
   * 分页查询数据
   *
   * @param pageable 分页对象
   * @param integral 实体对象
   * @return
   */
  @Override
  public Page<Integral> findByConditions(Pageable pageable, Integral integral) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (Objects.isNull(integral)) {
      integral = new Integral();
    }
    integral.setTenantCode(TenantUtils.getTenantCode());
    return this.integralRepository.findByConditions(pageable, integral);
  }

  /**
   * 新增数据
   *
   * @param integral 实体对象
   * @return 新增结果
   */
  @Transactional
  @Override
  public Integral create(Integral integral) {
    this.createValidate(integral);
    this.integralRepository.saveOrUpdate(integral);
    return integral;
  }

  /**
   * 创建验证
   *
   * @param integral
   */
  private void createValidate(Integral integral) {
    Validate.notNull(integral, "新增时，对象信息不能为空！");
    integral.setId(null);
    Validate.notBlank(integral.getParentCode(), "新增数据时，上层业务编码不能为空！");
    Validate.notBlank(integral.getDynamicFormCode(), "新增数据时，表单编码不能为空！");
    Validate.notBlank(integral.getIntegralRuleCode(), "新增数据时，积分规则编码不能为空！");
    Validate.notBlank(integral.getIntegralRuleId(), "新增数据时，积分规则编码不能为空！");
    Validate.notBlank(integral.getIntegralRuleName(), "新增数据时，积分规则名称不能为空！");
    Validate.notBlank(integral.getIntegralTaskTypeCode(), "新增数据时，积分任务类型编码不能为空！");
    Validate.notBlank(integral.getIntegralTaskTypeName(), "新增数据时，积分任务类型名称不能为空！");
    integral.setTenantCode(TenantUtils.getTenantCode());
  }
}
