/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.integral.local.listerner;

import cn.hutool.core.date.DateUtil;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.sfa.business.integral.local.entity.Integral;
import com.biz.crm.sfa.business.integral.local.service.IntegralService;
import com.biz.crm.sfa.business.integral.rule.sdk.service.IntegralRuleVoService;
import com.biz.crm.sfa.business.integral.rule.sdk.vo.IntegralCalculateRuleVo;
import com.biz.crm.sfa.business.integral.rule.sdk.vo.IntegralRuleVo;
import com.biz.crm.sfa.business.step.sdk.listerner.StepFormIntegralListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class StepFormIntegralListenerImpl
implements StepFormIntegralListener {
    @Autowired
    private IntegralRuleVoService integralRuleVoService;
    @Autowired
    private IntegralService integralService;
    @Autowired
    private UserFeignVoService userFeignVoService;
    @Autowired
    private LoginUserService loginUserService;

    public void onCreateIntegral(String parentCode, String dynamicKey, String dynamicFormCode) {
        IntegralRuleVo integralRuleVo = this.integralRuleVoService.findByLoginUser();
        if (Objects.isNull(integralRuleVo)) {
            return;
        }
        List integralCalculateRuleVos = integralRuleVo.getIntegralCalculateRuleVos();
        if (CollectionUtils.isEmpty((Collection)integralCalculateRuleVos)) {
            return;
        }
        List<IntegralCalculateRuleVo> calculateRuleVoList = integralCalculateRuleVos.stream().filter(integralCalculateRuleVo -> integralCalculateRuleVo.getIntegralTaskTypeCode().equals(dynamicKey)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(calculateRuleVoList)) {
            return;
        }
        Integral integral = this.assemblyIntegral(parentCode, dynamicKey, dynamicFormCode, calculateRuleVoList, integralRuleVo);
        this.integralService.create(integral);
    }

    private Integral assemblyIntegral(String parentCode, String dynamicKey, String dynamicFormCode, List<IntegralCalculateRuleVo> calculateRuleVoList, IntegralRuleVo integralRuleVo) {
        LoginUserDetails loginDetails = (LoginUserDetails)this.loginUserService.getLoginDetails(LoginUserDetails.class);
        IntegralCalculateRuleVo integralCalculateRuleVo = calculateRuleVoList.get(0);
        Integer integralTaskReward = integralCalculateRuleVo.getIntegralTaskReward();
        Integral integral = new Integral();
        integral.setParentCode(parentCode);
        integral.setDynamicKey(dynamicKey);
        integral.setDynamicFormCode(dynamicFormCode);
        integral.setIntegralRuleId(integralRuleVo.getId());
        integral.setIntegralRuleCode(integralRuleVo.getIntegralRuleCode());
        integral.setIntegralRuleName(integralRuleVo.getIntegralRuleName());
        integral.setIntegralYearMonth(DateUtil.format((Date)new Date(), (String)"yyyy-MM"));
        integral.setIntegralNum(integralTaskReward);
        integral.setIntegralTaskTypeCode(integralCalculateRuleVo.getIntegralTaskTypeCode());
        integral.setIntegralTaskTypeName(integralCalculateRuleVo.getIntegralTaskTypeName());
        List userVos = this.userFeignVoService.findByUserNames(Collections.singletonList(loginDetails.getAccount()));
        if (!CollectionUtils.isEmpty((Collection)userVos)) {
            UserVo userVo = (UserVo)userVos.get(0);
            integral.setCreateOrgCode(userVo.getOrgCode());
            integral.setCreateOrgName(userVo.getOrgName());
            integral.setCreatePosCode(userVo.getPositionCode());
            integral.setCreatePosName(userVo.getPositionName());
            integral.setCreatePositionLevelCode(userVo.getPositionLevelCode());
            integral.setCreatePositionLevelName(userVo.getPositionLevelName());
        }
        return integral;
    }
}

