/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.integral.local.service.internal;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.sfa.business.integral.local.enums.IntegralOrgTyepEnum;
import com.biz.crm.sfa.business.integral.local.repository.IntegralRepository;
import com.biz.crm.sfa.business.integral.local.service.IntegralReportService;
import com.biz.crm.sfa.business.integral.sdk.dto.IntegralCountDto;
import com.biz.crm.sfa.business.integral.sdk.vo.IntegralCountVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class IntegralReportServiceImpl
implements IntegralReportService {
    private static final Logger log = LoggerFactory.getLogger(IntegralReportServiceImpl.class);
    @Autowired
    private IntegralRepository integralRepository;
    @Autowired
    private UserFeignVoService userFeignVoService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private OrgVoService orgVoService;

    @Override
    public Page<IntegralCountVo> findIntegralCountByConditions(Pageable pageable, IntegralCountDto integralCountDto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(integralCountDto)) {
            integralCountDto = new IntegralCountDto();
        }
        integralCountDto.setTenantCode(TenantUtils.getTenantCode());
        Page<IntegralCountVo> integralCountVoPage = this.integralRepository.findIntegralCountByConditions(pageable, integralCountDto);
        this.assemblyIntegralCountVo(integralCountVoPage.getRecords());
        return integralCountVoPage;
    }

    @Override
    public IntegralCountVo findByRangType(String rangType) {
        LoginUserDetails loginDetails = (LoginUserDetails)this.loginUserService.getLoginDetails(LoginUserDetails.class);
        String orgCode = loginDetails.getOrgCode();
        IntegralCountDto integralCountDto = new IntegralCountDto();
        integralCountDto.setIntegralYearMonth(DateUtil.format((Date)new Date(), (String)"yyyy-MM"));
        integralCountDto.setTenantCode(TenantUtils.getTenantCode());
        integralCountDto.setCreateAccount(loginDetails.getAccount());
        integralCountDto = this.getSearchVo(orgCode, integralCountDto, rangType);
        return this.integralRepository.findIntegralCountByCreateAccount(integralCountDto);
    }

    @Override
    public Page<IntegralCountVo> findIntegralCountAppByConditions(Pageable pageable, IntegralCountDto integralCountDto) {
        LoginUserDetails loginDetails = (LoginUserDetails)this.loginUserService.getLoginDetails(LoginUserDetails.class);
        String orgCode = loginDetails.getOrgCode();
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(integralCountDto)) {
            integralCountDto = new IntegralCountDto();
        }
        integralCountDto.setIntegralYearMonth(DateUtil.format((Date)new Date(), (String)"yyyy-MM"));
        integralCountDto.setTenantCode(TenantUtils.getTenantCode());
        integralCountDto = this.getSearchVo(orgCode, integralCountDto, integralCountDto.getRangType());
        Page<IntegralCountVo> integralCountVoPage = this.integralRepository.findIntegralCountByConditions(pageable, integralCountDto);
        this.assemblyIntegralCountVo(integralCountVoPage.getRecords());
        return integralCountVoPage;
    }

    private void assemblyIntegralCountVo(List<IntegralCountVo> integralCountVoList) {
        List accouts;
        List userVos;
        if (!CollectionUtils.isEmpty(integralCountVoList) && !CollectionUtils.isEmpty((Collection)(userVos = this.userFeignVoService.findByUserNames(accouts = integralCountVoList.stream().map(IntegralCountVo::getCreateAccount).collect(Collectors.toList()))))) {
            Map<String, UserVo> userVoMap = userVos.stream().collect(Collectors.toMap(UserVo::getUserName, o -> o));
            integralCountVoList.forEach(integralCountVo -> {
                UserVo userVo = (UserVo)userVoMap.get(integralCountVo.getCreateAccount());
                integralCountVo.setCreateOrgCode(userVo.getOrgCode());
                integralCountVo.setCreateOrgName(userVo.getOrgName());
                integralCountVo.setCreatePosCode(userVo.getPositionCode());
                integralCountVo.setCreatePosName(userVo.getPositionName());
                integralCountVo.setCreatePositionLevelCode(userVo.getPositionLevelCode());
                integralCountVo.setCreatePositionLevelName(userVo.getPositionLevelName());
            });
        }
    }

    private IntegralCountDto getSearchVo(String userOrgCode, IntegralCountDto integralCountDto, String orgRange) {
        if (IntegralOrgTyepEnum.NOW_ORG.getDictCode().equals(orgRange)) {
            ArrayList<String> orgCodeList = new ArrayList<String>();
            orgCodeList.add(userOrgCode);
            integralCountDto.setOrgCodeList(orgCodeList);
        }
        if (IntegralOrgTyepEnum.ALL_ORG.getDictCode().equals(orgRange) || StringUtils.isBlank((CharSequence)orgRange)) {
            List allParentByOrgCode = this.orgVoService.findAllParentByOrgCode(userOrgCode);
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)allParentByOrgCode) ? 1 : 0) != 0, (String)"\u5f53\u524d\u767b\u5f55\u4eba\u7ec4\u7ec7\u6570\u636e\u6709\u8bef\uff01", (Object[])new Object[0]);
            List orgVos = allParentByOrgCode.stream().filter(orgVo -> StringUtils.isBlank((CharSequence)orgVo.getParentCode())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(orgVos)) {
                integralCountDto.setOrgCodeList(Collections.singletonList(userOrgCode));
            } else {
                List allChildrenOrg = this.orgVoService.findAllChildrenByOrgCode(((OrgVo)orgVos.get(0)).getOrgCode());
                List orgCodes = allChildrenOrg.stream().map(OrgVo::getOrgCode).collect(Collectors.toList());
                integralCountDto.setOrgCodeList(orgCodes);
            }
        }
        if (IntegralOrgTyepEnum.AFTER_ORG.getDictCode().equals(orgRange)) {
            List allChildrenOrg = this.orgVoService.findAllChildrenByOrgCode(userOrgCode);
            List allChildrenOrgList = allChildrenOrg.stream().map(OrgVo::getOrgCode).collect(Collectors.toList());
            integralCountDto.setOrgCodeList(allChildrenOrgList);
        }
        return integralCountDto;
    }
}

