package com.biz.crm.sfa.business.integral.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @description: 积分表
 * @author: rentao
 * @date: 2022/6/24 17:44
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = " ", description = "积分表")
@Entity
@TableName("sfa_integral")
@Table(name = "sfa_integral", indexes = {
    @Index(name = "sfa_integral_index1", columnList = "integral_rule_code"),
    @Index(name = "sfa_integral_index2", columnList = "parent_code,dynamic_form_code",unique = true)
})
@org.hibernate.annotations.Table(appliesTo = "sfa_integral", comment = "积分表")
public class Integral extends TenantFlagOpEntity {

  private static final long serialVersionUID = -704490297884280718L;

  @ApiModelProperty("上层业务编码")
  @Column(name = "parent_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '上层业务编码'")
  private String parentCode;

  @ApiModelProperty("表单编码")
  @Column(name = "dynamic_form_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '表单编码'")
  private String dynamicFormCode;

  @ApiModelProperty("步骤编码 ")
  @Column(name = "dynamic_key", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '步骤编码'")
  private String dynamicKey;

  @ApiModelProperty("积分规则编码")
  @Column(name = "integral_rule_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '积分规则编码'")
  private String integralRuleCode;

  @ApiModelProperty("积分规则id")
  @Column(name = "integral_rule_id", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '积分规则编码'")
  private String integralRuleId;

  @ApiModelProperty("积分规则名称")
  @Column(name = "integral_rule_name", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '积分规则名称'")
  private String integralRuleName;

  @ApiModelProperty("年月")
  @Column(name = "integral_year_month", length = 7, columnDefinition = "VARCHAR(7) COMMENT '年月'")
  private String integralYearMonth;

  @ApiModelProperty("积分数")
  @Column(name = "integral_num", columnDefinition = "INT(7) COMMENT '积分数'")
  private Integer integralNum;

  @ApiModelProperty("积分任务类型编码")
  @Column(name = "integral_task_type_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '积分任务类型编码'")
  private String integralTaskTypeCode;

  @ApiModelProperty("积分任务类型名称")
  @Column(name = "integral_task_type_name", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '积分任务类型名称'")
  private String integralTaskTypeName;

  @ApiModelProperty("创建人岗位名称")
  @Column(name = "create_pos_name", length = 200, columnDefinition = "varchar(200) COMMENT '创建人岗位名称'")
  private String createPosName;

  @ApiModelProperty("创建人岗位")
  @Column(name = "create_pos_code", length = 200, columnDefinition = "varchar(200) COMMENT '创建人岗位'")
  private String createPosCode;

  @ApiModelProperty("创建人组织")
  @Column(name = "create_org_code", length = 200, columnDefinition = "varchar(200) COMMENT '创建人组织'")
  private String createOrgCode;

  @ApiModelProperty("创建人组织名称")
  @Column(name = "create_org_name", length = 200, columnDefinition = "varchar(200) COMMENT '创建人组织名称'")
  private String createOrgName;

  @ApiModelProperty("职位级别编码")
  @Column(name = "create_position_level_code", length = 200, columnDefinition = "varchar(200) COMMENT '职位级别编码'")
  private String createPositionLevelCode;

  @ApiModelProperty("职位级别编码")
  @Column(name = "create_position_level_name", length = 200, columnDefinition = "varchar(200) COMMENT '职位级别编码'")
  private String createPositionLevelName;

}
