package com.biz.crm.sfa.business.integral.local.enums;

import com.biz.crm.sfa.business.integral.rule.sdk.enums.IntegralRuleScopeEnum;
import java.util.Arrays;
import java.util.Objects;

/**
 * @description: app端查询积分权限
 * @author: rentao
 * @date: 2022/6/27 17:12
 */
public enum IntegralOrgTyepEnum {

  NOW_ORG("now_org","now_org", "本部门","1"),
  ALL_ORG("all_org","all_org", "本公司","2"),
  AFTER_ORG("now_org_type", "now_org_type","当前组织及下级组织","3");
  private String key;
  /** 字典编码 */
  private String dictCode;
  /** 字典值 */
  private String value;
  /** 字典排序 */
  private String order;

  IntegralOrgTyepEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 IntegralOrgTyepEnum
   *
   * @param key
   * @return
   */
  public static IntegralOrgTyepEnum getByKey(String key) {
    return Arrays.stream(IntegralOrgTyepEnum.values())
        .filter(item -> Objects.equals(item.getKey(), key))
        .findFirst()
        .orElse(null);
  }

  /**
   * 通过dictCode获取 IntegralOrgTyepEnum
   *
   * @param dictCode
   * @return
   */
  public static IntegralOrgTyepEnum getByDictCode(String dictCode) {
    return Arrays.stream(IntegralOrgTyepEnum.values())
        .filter(item -> Objects.equals(item.getKey(), dictCode))
        .findFirst()
        .orElse(null);
  }

}
