package com.biz.crm.sfa.business.integral.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.sfa.business.integral.local.entity.Integral;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.integral.sdk.dto.IntegralCountDto;
import com.biz.crm.sfa.business.integral.sdk.vo.IntegralCountVo;
import org.apache.ibatis.annotations.Param;

/**
 * 积分表(Integral)表mybatis访问层
 *
 * @author rentao
 * @since 2022-06-25 10:15:03
 */
public interface IntegralMapper extends BaseMapper<Integral> {

  /**
   * 分页查询所有数据
   *
   * @param page 分页对象
   * @param integral 查询实体
   * @return 所有数据
  */
  public Page<Integral> findByConditions(@Param("page") Page<Integral> page, @Param("dto") Integral integral);

  /**
   * 分页统计积分数据(排名 排名是连续的，如果两个人是第一名)
   *
   * @param page 分页对象
   * @param integralCountDto 查询实体
   * @return 所有数据
   */
  public Page<IntegralCountVo> findIntegralCountByConditions(@Param("page") Page<IntegralCountVo> page, @Param("dto") IntegralCountDto integralCountDto);

  /**
   * // </br>
   *
   * @param integralCountDto
   * @author rentao
   * @date a
  */
  IntegralCountVo findIntegralCountByCreateAccount(@Param("dto") IntegralCountDto integralCountDto);
}

