package com.biz.crm.sfa.business.integral.local.repository;



import com.biz.crm.sfa.business.integral.local.entity.Integral;
import com.biz.crm.sfa.business.integral.local.mapper.IntegralMapper;
import com.biz.crm.sfa.business.integral.sdk.dto.IntegralCountDto;
import com.biz.crm.sfa.business.integral.sdk.vo.IntegralCountVo;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import java.util.List;

/**
 * 积分表(Integral)表数据库访问层
 *
 * @author rentao
 * @since 2022-06-25 10:14:59
 */
@Component
public class IntegralRepository extends ServiceImpl<IntegralMapper, Integral> {

  @Autowired
  private IntegralMapper integralMapper;
  
   /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param integral 实体对象
   * @return
   */
  public Page<Integral> findByConditions(Pageable pageable, Integral integral) {
    Page<Integral> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<Integral> pageList = this.integralMapper.findByConditions(page, integral);
    return pageList;
  }


  /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param integralCountDto 实体对象
   * @return
   */
  public Page<IntegralCountVo> findIntegralCountByConditions(Pageable pageable, IntegralCountDto integralCountDto) {
    Page<IntegralCountVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<IntegralCountVo> pageList = this.integralMapper.findIntegralCountByConditions(page, integralCountDto);
    return pageList;
  }


  /**
   * CreateAccoun 查询数据并分组
   * @param integralCountDto 实体对象
   * @return
   */
  public IntegralCountVo findIntegralCountByCreateAccount(IntegralCountDto integralCountDto) {
    IntegralCountVo integralCountVo = this.integralMapper.findIntegralCountByCreateAccount(integralCountDto);
    return integralCountVo;
  }
}

