package com.biz.crm.sfa.business.integral.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.integral.local.entity.Integral;
import com.biz.crm.sfa.business.integral.sdk.dto.IntegralCountDto;
import com.biz.crm.sfa.business.integral.sdk.vo.IntegralCountVo;
import org.springframework.data.domain.Pageable;

/**
 * @description: 积分报表
 * @author: rentao
 * @date: 2022/6/27 10:09
 */
public interface IntegralReportService {

  /**
   * 积分排名分页接口
   *
   * @param pageable
   * @param integralCountDto
   * @author rentao
   * @date a
  */
  Page<IntegralCountVo> findIntegralCountByConditions(Pageable pageable, IntegralCountDto integralCountDto);

  /**
   * 查询登陆人积分总数和排名
   *
   * @param rangType  范围类型
   * @author rentao
   * @date a
   */
  IntegralCountVo findByRangType(String rangType);

  /**
   * 积分排名分页接口
   *
   * @param pageable
   * @param integralCountDto
   * @author rentao
   * @date a
   */
  Page<IntegralCountVo> findIntegralCountAppByConditions(Pageable pageable, IntegralCountDto integralCountDto);
}
