package com.biz.crm.sfa.business.integral.rule.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @description: 积分计算规则
 * @author: rentao
 * @date: 2022/6/22 11:22
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "IntegralRuleScope", description = "积分计算规则")
@Entity
@TableName("sfa_integral_calculate_rule")
@Table(name = "sfa_integral_calculate_rule", indexes = {
    @Index(name = "sfa_integral_calculate_rule_index1", columnList = "integral_rule_code"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_integral_calculate_rule", comment = "积分计算规则")
public class IntegralCalculateRule  extends TenantOpEntity {

  private static final long serialVersionUID = -3052295033948029174L;

  /**
   * 积分规则编码
   */
  @ApiModelProperty("积分规则编码")
  @Column(name = "integral_rule_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '积分规则编码'")
  private String integralRuleCode;

  /**
   * 积分任务类型编码
   */
  @ApiModelProperty("积分任务类型编码")
  @Column(name = "integral_task_type_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '积分任务类型编码'")
  private String integralTaskTypeCode;

  /**
   * 积分任务类型名称
   */
  @ApiModelProperty("积分任务类型名称")
  @Column(name = "integral_task_type_name", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '积分任务类型名称'")
  private String integralTaskTypeName;

  /**
   * 积分任务加积分数-任务完成奖励
   */
  @ApiModelProperty("积分任务加积分数")
  @Column(name = "integral_task_reward", columnDefinition = "INT(7) COMMENT '积分任务加积分数'")
  private Integer integralTaskReward;

  /**
   * 设定状态：0：禁用/废弃；1：正常
   */
  @ApiModelProperty(name="state" , value = "设定状态：0：禁用/废弃；1：正常")
  @Column(name="state" ,  nullable = false , columnDefinition = "int(11) COMMENT '设定状态：0：禁用/废弃；1：正常'")
  private Integer state = 1;
}
