package com.biz.crm.sfa.business.integral.rule.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.sfa.business.integral.rule.local.entity.IntegralCalculateRule;
import com.biz.crm.sfa.business.integral.rule.local.entity.IntegralRuleScope;
import com.biz.crm.sfa.business.integral.rule.local.mapper.IntegralRuleScopeMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Set;
import org.springframework.stereotype.Component;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import java.util.List;

/**
 * 积分范围表(IntegralRuleScope)表数据库访问层
 *
 * @author rentao
 * @since 2022-06-22 12:31:39
 */
@Component
public class IntegralRuleScopeRepository extends ServiceImpl<IntegralRuleScopeMapper, IntegralRuleScope> {

  /**
   * 根据 integralRuleCode 更新启禁用装填
   * @param integralRuleCodes
   * @return
   */
  public void updateStateByIntegralRuleCode(List<String> integralRuleCodes,int state) {
    this.lambdaUpdate()
        .in(IntegralRuleScope::getIntegralRuleCode, integralRuleCodes)
        .set(IntegralRuleScope::getState,state)
        .update();
  }

  /**
   * 根据integralRuleCode 查询集合
   * @param integralRuleCodes
   * @return
   */
  public void deleteByIntegralRuleCode(Set<String> integralRuleCodes){
    this.lambdaUpdate()
        .in(IntegralRuleScope::getIntegralRuleCode, integralRuleCodes)
        .remove();
  }

  /**
   * 根据integralRuleCode 查询集合
   * @param integralRuleCode
   * @return
   */
  public List<IntegralRuleScope> findByIntegralRuleCode(String integralRuleCode){
    return this.lambdaQuery()
        .eq(IntegralRuleScope::getIntegralRuleCode, integralRuleCode)
        .eq(IntegralRuleScope::getState,1).list();
  }

  /**
   * 根据scopeCode查询集合
   * @param scopeCodes
   * @return
   */
  public List<IntegralRuleScope> findByScopeCodes(List<String> scopeCodes){
    return this.lambdaQuery()
        .in(IntegralRuleScope::getScopeCode, scopeCodes)
        .list();
  }
}

