/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.integral.rule.local.service.internal;

import com.biz.crm.sfa.business.integral.rule.local.entity.IntegralCalculateRule;
import com.biz.crm.sfa.business.integral.rule.local.repository.IntegralCalculateRuleRepository;
import com.biz.crm.sfa.business.integral.rule.local.service.IntegralCalculateRuleService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class IntegralCalculateRuleServiceImpl
implements IntegralCalculateRuleService {
    private static final Logger log = LoggerFactory.getLogger(IntegralCalculateRuleServiceImpl.class);
    @Autowired
    private IntegralCalculateRuleRepository integralCalculateRuleRepository;

    @Override
    public List<IntegralCalculateRule> findByIntegralRuleCode(String integralRuleCode) {
        if (StringUtils.isBlank((CharSequence)integralRuleCode)) {
            return null;
        }
        return this.integralCalculateRuleRepository.findByIntegralRuleCode(integralRuleCode);
    }

    @Override
    @Transactional
    public void createBatch(List<IntegralCalculateRule> integralCalculateRules) {
        Validate.isTrue((!CollectionUtils.isEmpty(integralCalculateRules) ? 1 : 0) != 0, (String)"\u65b0\u589e\u65f6\uff0c\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        integralCalculateRules.forEach(e -> this.createValidate((IntegralCalculateRule)((Object)e)));
        this.integralCalculateRuleRepository.saveBatch(integralCalculateRules);
    }

    @Override
    @Transactional
    public void updateBatch(List<IntegralCalculateRule> integralCalculateRules) {
        Validate.isTrue((!CollectionUtils.isEmpty(integralCalculateRules) ? 1 : 0) != 0, (String)"\u7f16\u8f91\u65f6\uff0c\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        HashSet<String> integralRuleCodes = new HashSet<String>();
        integralCalculateRules.forEach(e -> {
            this.updateValidate((IntegralCalculateRule)((Object)e));
            integralRuleCodes.add(e.getIntegralRuleCode());
            e.setId(null);
        });
        Validate.isTrue((!CollectionUtils.isEmpty(integralRuleCodes) && integralRuleCodes.size() == 1 ? 1 : 0) != 0, (String)"\u4e00\u6b21\u7f16\u8f91\u53ea\u80fd\u64cd\u4f5c\u89c4\u5219\u7f16\u7801\u76f8\u540c\u7684\u4e00\u6279\u6570\u636e", (Object[])new Object[0]);
        this.integralCalculateRuleRepository.deleteByIntegralRuleCode(integralRuleCodes);
        this.integralCalculateRuleRepository.saveBatch(integralCalculateRules);
    }

    @Override
    @Transactional
    public void deleteByIntegralRuleCode(Set<String> integralRuleCodes) {
        this.integralCalculateRuleRepository.deleteByIntegralRuleCode(integralRuleCodes);
    }

    @Override
    @Transactional
    public void enableByIntegralRuleCode(List<String> integralRuleCodes) {
        this.integralCalculateRuleRepository.updateStateByIntegralRuleCode(integralRuleCodes, 1);
    }

    @Override
    @Transactional
    public void disableByIntegralRuleCode(List<String> integralRuleCodes) {
        this.integralCalculateRuleRepository.updateStateByIntegralRuleCode(integralRuleCodes, 0);
    }

    private void createValidate(IntegralCalculateRule integralCalculateRule) {
        Validate.notNull((Object)((Object)integralCalculateRule), (String)"\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        integralCalculateRule.setId(null);
        Validate.notBlank((CharSequence)integralCalculateRule.getIntegralRuleCode(), (String)"\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u79ef\u5206\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)integralCalculateRule.getIntegralTaskTypeCode(), (String)"\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u79ef\u5206\u4efb\u52a1\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)integralCalculateRule.getIntegralTaskTypeName(), (String)"\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u79ef\u5206\u4efb\u52a1\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        integralCalculateRule.setTenantCode(TenantUtils.getTenantCode());
    }

    private void updateValidate(IntegralCalculateRule integralCalculateRule) {
        Validate.notNull((Object)((Object)integralCalculateRule), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)integralCalculateRule.getIntegralRuleCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79ef\u5206\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)integralCalculateRule.getIntegralTaskTypeCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79ef\u5206\u4efb\u52a1\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)integralCalculateRule.getIntegralTaskTypeName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79ef\u5206\u4efb\u52a1\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        integralCalculateRule.setTenantCode(TenantUtils.getTenantCode());
    }
}

