/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.integral.rule.local.service.internal;

import com.biz.crm.sfa.business.integral.rule.local.entity.IntegralRuleScope;
import com.biz.crm.sfa.business.integral.rule.local.repository.IntegralRuleScopeRepository;
import com.biz.crm.sfa.business.integral.rule.local.service.IntegralRuleScopeService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class IntegralRuleScopeServiceImpl
implements IntegralRuleScopeService {
    private static final Logger log = LoggerFactory.getLogger(IntegralRuleScopeServiceImpl.class);
    @Autowired
    private IntegralRuleScopeRepository integralRuleScopeRepository;

    @Override
    public List<IntegralRuleScope> findByIntegralRuleCode(String integralRuleCode) {
        if (StringUtils.isBlank((CharSequence)integralRuleCode)) {
            return null;
        }
        return this.integralRuleScopeRepository.findByIntegralRuleCode(integralRuleCode);
    }

    @Override
    public List<IntegralRuleScope> findByScopeCodes(List<String> scopeCodes) {
        if (CollectionUtils.isEmpty(scopeCodes)) {
            return null;
        }
        return this.integralRuleScopeRepository.findByScopeCodes(scopeCodes);
    }

    @Override
    @Transactional
    public void createBatch(List<IntegralRuleScope> integralRuleScopes) {
        Validate.isTrue((!CollectionUtils.isEmpty(integralRuleScopes) ? 1 : 0) != 0, (String)"\u65b0\u589e\u65f6\uff0c\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        integralRuleScopes.forEach(e -> this.createValidate((IntegralRuleScope)((Object)e)));
        this.integralRuleScopeRepository.saveBatch(integralRuleScopes);
    }

    @Override
    @Transactional
    public void updateBatch(List<IntegralRuleScope> integralRuleScopes) {
        Validate.isTrue((!CollectionUtils.isEmpty(integralRuleScopes) ? 1 : 0) != 0, (String)"\u7f16\u8f91\u65f6\uff0c\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        HashSet<String> integralRuleCodes = new HashSet<String>();
        integralRuleScopes.forEach(e -> {
            this.updateValidate((IntegralRuleScope)((Object)e));
            integralRuleCodes.add(e.getIntegralRuleCode());
            e.setId(null);
        });
        Validate.isTrue((!CollectionUtils.isEmpty(integralRuleCodes) && integralRuleCodes.size() == 1 ? 1 : 0) != 0, (String)"\u4e00\u6b21\u7f16\u8f91\u53ea\u80fd\u64cd\u4f5c\u89c4\u5219\u7f16\u7801\u76f8\u540c\u7684\u4e00\u6279\u6570\u636e", (Object[])new Object[0]);
        this.integralRuleScopeRepository.deleteByIntegralRuleCode(integralRuleCodes);
        this.integralRuleScopeRepository.saveBatch(integralRuleScopes);
    }

    @Override
    @Transactional
    public void disableByIntegralRuleCode(List<String> integralRuleCodes) {
        this.integralRuleScopeRepository.updateStateByIntegralRuleCode(integralRuleCodes, 0);
    }

    @Override
    @Transactional
    public void deleteByIntegralRuleCode(Set<String> integralRuleCodes) {
        this.integralRuleScopeRepository.deleteByIntegralRuleCode(integralRuleCodes);
    }

    @Override
    @Transactional
    public void enableByIntegralRuleCode(List<String> integralRuleCodes) {
        this.integralRuleScopeRepository.updateStateByIntegralRuleCode(integralRuleCodes, 1);
    }

    private void createValidate(IntegralRuleScope integralRuleScope) {
        Validate.notNull((Object)((Object)integralRuleScope), (String)"\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        integralRuleScope.setId(null);
        Validate.notBlank((CharSequence)integralRuleScope.getIntegralRuleCode(), (String)"\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u79ef\u5206\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)integralRuleScope.getScopeCode(), (String)"\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u88ab\u9009\u5b9a\u7684\u4e1a\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)integralRuleScope.getScopeName(), (String)"\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u88ab\u9009\u5b9a\u7684\u4e1a\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)integralRuleScope.getScopeType(), (String)"\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u88ab\u9009\u5b9a\u7684\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        integralRuleScope.setTenantCode(TenantUtils.getTenantCode());
    }

    private void updateValidate(IntegralRuleScope integralRuleScope) {
        Validate.notNull((Object)((Object)integralRuleScope), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)integralRuleScope.getIntegralRuleCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79ef\u5206\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)integralRuleScope.getScopeCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u88ab\u9009\u5b9a\u7684\u4e1a\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)integralRuleScope.getScopeName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u88ab\u9009\u5b9a\u7684\u4e1a\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)integralRuleScope.getScopeType(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u88ab\u9009\u5b9a\u7684\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        integralRuleScope.setTenantCode(TenantUtils.getTenantCode());
    }
}

