package com.biz.crm.sfa.business.integral.rule.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.sfa.business.integral.rule.sdk.service.IntegralRuleVoService;
import com.biz.crm.sfa.business.integral.rule.sdk.vo.IntegralRuleVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 积分规则主表(IntegralRuleVo)表相关的http接口
 *
 * @author rentao
 * @since 2022-06-22 12:31:34
 */
@RestController
@RequestMapping("/v1/integralRule/integralRule")
@Slf4j
@Api(tags = "积分规则主表:IntegralRuleVo:积分规则主表")
public class IntegralRuleVoController {

  @Autowired private IntegralRuleVoService integralRuleVoService;

  /**
   * 通过主键查询单条数据详情
   *
   * @param id 主键
   * @return 单条数据
   */
  @ApiOperation(value = "通过主键查询单条数据详情")
  @GetMapping("findDetailById/{id}")
  public Result<IntegralRuleVo> findDetailById(
      @PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      IntegralRuleVo integralRuleVo = this.integralRuleVoService.findDetailById(id);
      return Result.ok(integralRuleVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  @ApiOperation(value = "获取当前用户对应的积分规则的详情——小程序端")
  @GetMapping("/findByLoginUser")
  public Result <IntegralRuleVo> findByLoginUser(){
    try {
      IntegralRuleVo integralRuleVo = this.integralRuleVoService.findByLoginUser();
      return Result.ok(integralRuleVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
