package com.biz.crm.sfa.business.integral.rule.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @description: 积分规则主表
 * @author: rentao
 * @date: 2022/6/22 11:08
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = " ", description = "积分规则主表")
@Entity
@TableName("sfa_integral_rule")
@Table(name = "sfa_integral_rule", indexes = {
    @Index(name = "sfa_integral_rule_index1", columnList = "integral_rule_code,tenant_code", unique = true),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_integral_rule", comment = "积分规则主表")
public class IntegralRule extends TenantFlagOpEntity {

  private static final long serialVersionUID = -704490297884280718L;

  /**
   * 积分规则名称  sfa_integral_calculate_rule  IntegralCalculateRule
   */
  @ApiModelProperty("积分规则名称")
  @Column(name = "integral_rule_name", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '积分规则名称'")
  private String integralRuleName;

  /**
   * 开始时间
   */
  @ApiModelProperty("生效开始时间")
  @Column(name = "start_time", columnDefinition = "datetime COMMENT '生效开始时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startTime;

  /**
   * 结束时间
   */
  @ApiModelProperty("生效结束时间")
  @Column(name = "end_time", columnDefinition = "datetime COMMENT '生效结束时间'")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endTime;

  /**
   * 积分规则编码
   */
  @ApiModelProperty("积分规则编码")
  @Column(name = "integral_rule_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '积分规则编码'")
  private String integralRuleCode;

}
