package com.biz.crm.sfa.business.integral.rule.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * @description: 积分规则范围表
 * @author: rentao
 * @date: 2022/6/22 11:16
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "IntegralRuleScope", description = "积分规则范围表")
@Entity
@TableName("sfa_integral_rule_scope")
@Table(name = "sfa_integral_rule_scope", indexes = {
    @Index(name = "sfa_integral_rule_scope_index1", columnList = "integral_rule_code"),
})
@org.hibernate.annotations.Table(appliesTo = "sfa_integral_rule_scope", comment = "积分规则范围表")
public class IntegralRuleScope extends TenantOpEntity {

  private static final long serialVersionUID = 3076115513535191281L;

  /**
   * 积分规则编码
   */
  @ApiModelProperty("积分规则编码")
  @Column(name = "integral_rule_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) NOT NULL COMMENT '积分规则编码'")
  private String integralRuleCode;

  /**
   * 被选定的业务类型
   */
  @Column(name = "scope_type" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT '被选定的业务类型'")
  @ApiModelProperty("被选定的业务类型")
  private String scopeType;

  /**
   * 设定状态：0：禁用/废弃；1：正常
   */
  @ApiModelProperty(name="state" , value = "设定状态：0：禁用/废弃；1：正常")
  @Column(name="state" ,  nullable = false , columnDefinition = "int(11) COMMENT '设定状态：0：禁用/废弃；1：正常'")
  private Integer state = 1;

  /**
   * 被选定的业务编号
   */
  @Column(name = "scope_code" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT '被选定的业务编号'")
  @ApiModelProperty("被选定的业务编号")
  private String scopeCode;

  /**
   * 被选定的业务名称
   */
  @Column(name = "scope_name" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT '被选定的业务名称'")
  @ApiModelProperty("被选定的业务名称")
  private String scopeName;
}
