package com.biz.crm.sfa.business.integral.rule.local.repository;



import com.biz.crm.sfa.business.integral.rule.local.entity.IntegralCalculateRule;
import com.biz.crm.sfa.business.integral.rule.local.mapper.IntegralCalculateRuleMapper;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import java.util.List;

/**
 * 积分计算规则(IntegralCalculateRule)表数据库访问层
 *
 * @author rentao
 * @since 2022-06-22 12:31:33
 */
@Component
public class IntegralCalculateRuleRepository extends ServiceImpl<IntegralCalculateRuleMapper, IntegralCalculateRule> {

  /**
   * 根据 integralRuleCode 更新启禁用装填
   * @param integralRuleCodes
   * @return
   */
  public void updateStateByIntegralRuleCode(List<String> integralRuleCodes,int state) {
    this.lambdaUpdate()
            .in(IntegralCalculateRule::getIntegralRuleCode, integralRuleCodes)
            .set(IntegralCalculateRule::getState,state)
            .update();
  }

  /**
   * 根据integralRuleCode 查询集合
   * @param integralRuleCode
   * @return
   */
  public List<IntegralCalculateRule> findByIntegralRuleCode(String integralRuleCode){
   return this.lambdaQuery()
        .eq(IntegralCalculateRule::getIntegralRuleCode, integralRuleCode)
        .eq(IntegralCalculateRule::getState,1).list();
  }

  /**
   * 根据integralRuleCode 查询集合
   * @param integralRuleCodes
   * @return
   */
  public void deleteByIntegralRuleCode(Set<String> integralRuleCodes){
    this.lambdaUpdate()
        .in(IntegralCalculateRule::getIntegralRuleCode, integralRuleCodes)
        .remove();
  }
}

