package com.biz.crm.sfa.business.integral.rule.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.sfa.business.integral.rule.local.entity.IntegralRule;
import com.biz.crm.sfa.business.integral.rule.local.mapper.IntegralRuleMapper;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import java.util.List;

/**
 * 积分主表(IntegralRule)表数据库访问层
 *
 * @author rentao
 * @since 2022-06-22 12:31:36
 */
@Component
public class IntegralRuleRepository extends ServiceImpl<IntegralRuleMapper, IntegralRule> {

  @Autowired
  private IntegralRuleMapper integralRuleMapper;
  
   /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param integralRule 实体对象
   * @return
   */
  public Page<IntegralRule> findByConditions(Pageable pageable, IntegralRule integralRule) {
    Page<IntegralRule> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<IntegralRule> pageList = this.integralRuleMapper.findByConditions(page, integralRule);
    return pageList;
  }
  
  /**
   * 根据id集合更新启禁用装填
   * @param ids 分页对象
   * @param enableStatus 启禁用状态对象
   * @return
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
    this.lambdaUpdate()
            .in(IntegralRule::getId, ids)
            .set(IntegralRule::getEnableStatus, enableStatus.getCode())
            .update();
  }

  /**
   * 根据id集合查询
   * @param ids
   * @return
   */
  public List<IntegralRule> findByIds(List<String> ids) {
   return this.lambdaQuery()
            .in(IntegralRule::getId, ids)
            .eq(IntegralRule::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
            .list();
  }


  /**
   * 根据integralRuleCode查询
   * @param integralRuleCode
   * @return
   */
  public IntegralRule findByCode(String integralRuleCode) {
   return this.lambdaQuery()
            .eq(IntegralRule::getIntegralRuleCode, integralRuleCode)
            .eq(IntegralRule::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
            .one();
  }
}

