package com.biz.crm.sfa.business.integral.rule.local.service;


import com.biz.crm.sfa.business.integral.rule.local.entity.IntegralCalculateRule;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.Set;
import org.springframework.data.domain.Pageable;
import java.util.List;

/**
 * 积分计算规则(IntegralCalculateRule)表服务接口
 *
 * @author rentao
 * @since 2022-06-22 12:31:31
 */
public interface IntegralCalculateRuleService{

  /**
   * 通过integralRuleCode查询集合数据
   * @param integralRuleCode 主键
   * @return 集合数据
   */
  List<IntegralCalculateRule> findByIntegralRuleCode(String integralRuleCode);

  /**
   * 批量创建
   * @param integralCalculateRules
   * @return
   */
  void createBatch(List<IntegralCalculateRule> integralCalculateRules);

  /**
   * 批量修改
   * @param integralCalculateRules 实体对象
   * @return 修改结果
   */
  void updateBatch(List<IntegralCalculateRule> integralCalculateRules);


  /**
   * 删除数据
   * @param integralRuleCodes
   * @return 删除结果
   */
  void deleteByIntegralRuleCode(Set<String> integralRuleCodes);

  /**
   * 启用数据
   * @param integralRuleCodes
   * @return 删除结果
   */
  void enableByIntegralRuleCode(List<String> integralRuleCodes);

  /**
   * 禁用数据
   * @param integralRuleCodes
   * @return 删除结果
   */
  void disableByIntegralRuleCode(List<String> integralRuleCodes);

}

