package com.biz.crm.sfa.business.integral.rule.local.service;


import com.biz.crm.sfa.business.integral.rule.local.entity.IntegralCalculateRule;
import com.biz.crm.sfa.business.integral.rule.local.entity.IntegralRuleScope;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.integral.rule.sdk.dto.IntegralRuleScopeDto;
import java.util.Set;
import org.springframework.data.domain.Pageable;
import java.util.List;

/**
 * 积分范围表(IntegralRuleScope)表服务接口
 *
 * @author rentao
 * @since 2022-06-22 12:31:38
 */
public interface IntegralRuleScopeService{

  /**
   * 通过integralRuleCode查询集合数据
   * @param integralRuleCode
   * @return 集合数据
   */
  List<IntegralRuleScope> findByIntegralRuleCode(String integralRuleCode);

  /**
   * 通过scopeCode查询集合数据
   * @param scopeCodes
   * @return 集合数据
   */
  List<IntegralRuleScope> findByScopeCodes(List<String> scopeCodes);

  /**
   * 批量创建
   * @param integralRuleScopes
   * @return
   */
  void createBatch(List<IntegralRuleScope> integralRuleScopes);

  /**
   * 批量修改
   * @param integralRuleScopes 实体对象
   * @return 修改结果
   */
  void updateBatch(List<IntegralRuleScope> integralRuleScopes);

  /**
   * 禁用数据
   * @param integralRuleCodes
   * @return 删除结果
   */
  void disableByIntegralRuleCode(List<String> integralRuleCodes);


  /**
   * 删除数据
   * @param integralRuleCodes
   * @return 删除结果
   */
  void deleteByIntegralRuleCode(Set<String> integralRuleCodes);

  /**
   * 启用数据
   * @param integralRuleCodes
   * @return 删除结果
   */
  void enableByIntegralRuleCode(List<String> integralRuleCodes);

}

