package com.biz.crm.sfa.business.integral.rule.local.service;


import com.biz.crm.sfa.business.integral.rule.local.entity.IntegralRule;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.sfa.business.integral.rule.sdk.dto.IntegralRuleDto;
import org.springframework.data.domain.Pageable;
import java.util.List;

/**
 * 积分规则主表(IntegralRule)表服务接口
 *
 * @author rentao
 * @since 2022-06-22 12:31:35
 */
public interface IntegralRuleService{

  /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param integralRule 实体对象
   * @return
   */
  Page<IntegralRule> findByConditions(Pageable pageable, IntegralRule integralRule);
  
   /**
   * 通过主键查询单条数据
   * @param id 主键
   * @return 单条数据
   */
  IntegralRule findById(String id);

  /**
   * 通过integralRuleCode查询单条数据
   * @param integralRuleCode 主键
   * @return 单条数据
   */
  IntegralRule findByCode(String integralRuleCode);

   /**
   * 新增数据
   * @param integralRuleDto 实体对象
   * @return 新增结果
   */
  IntegralRule create(IntegralRuleDto integralRuleDto);
  
   /**
   * 修改新据
   * @param integralRuleDto 实体对象
   * @return 修改结果
   */
  IntegralRule update(IntegralRuleDto integralRuleDto);
  
  /**
   * 删除数据
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);
  
  /**
   * 启用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 启用结果
   */
  void enable(List<String> idList);
  
  /**
   * 禁用（单个或者批量）
   *
   * @param idList 主键结合
   * @return 禁用结果
   */
  void disable(List<String> idList);

}

