package com.biz.crm.sfa.business.integral.rule.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.sfa.business.integral.rule.local.repository.IntegralCalculateRuleRepository;
import com.biz.crm.sfa.business.integral.rule.local.entity.IntegralCalculateRule;
import com.biz.crm.sfa.business.integral.rule.local.service.IntegralCalculateRuleService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.beans.factory.annotation.Autowired;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;

import java.util.List;
import java.util.Objects;

/**
 * 积分计算规则(IntegralCalculateRule)表服务实现类
 *
 * @author rentao
 * @since 2022-06-22 12:31:32
 */
@Service
@Slf4j
public class IntegralCalculateRuleServiceImpl implements IntegralCalculateRuleService {

  @Autowired private IntegralCalculateRuleRepository integralCalculateRuleRepository;

  /**
   * 通过integralRuleCode查询集合数据
   * @param integralRuleCode 主键
   * @return 集合数据
   */
  @Override
  public List<IntegralCalculateRule> findByIntegralRuleCode(String integralRuleCode) {
    if (StringUtils.isBlank(integralRuleCode)) {
      return null;
    }
    return this.integralCalculateRuleRepository.findByIntegralRuleCode(integralRuleCode);
  }

  /**
   * 批量新增
   *
   * @param integralCalculateRules
   * @author rentao
   * @date a
   */
  @Override
  @Transactional
  public void createBatch(List<IntegralCalculateRule> integralCalculateRules) {
    Validate.isTrue(!CollectionUtils.isEmpty(integralCalculateRules), "新增时，数据不存在");
    integralCalculateRules.forEach(
        e -> {
          this.createValidate(e);
        });
    this.integralCalculateRuleRepository.saveBatch(integralCalculateRules);
  }

  /**
   * 批量修改
   * @param integralCalculateRules 实体对象
   * @return 修改结果
   */
  @Override
  @Transactional
  public void updateBatch(List<IntegralCalculateRule> integralCalculateRules) {
    Validate.isTrue(!CollectionUtils.isEmpty(integralCalculateRules), "编辑时，数据不存在");
    Set<String> integralRuleCodes = new HashSet<>();
    integralCalculateRules.forEach(
        e -> {
          this.updateValidate(e);
          integralRuleCodes.add(e.getIntegralRuleCode());
          e.setId(null);
        });
    Validate.isTrue(!CollectionUtils.isEmpty(integralRuleCodes) && integralRuleCodes.size() == 1 ,"一次编辑只能操作规则编码相同的一批数据");
    this.integralCalculateRuleRepository.deleteByIntegralRuleCode(integralRuleCodes);
    this.integralCalculateRuleRepository.saveBatch(integralCalculateRules);
  }

  /**
   * 删除数据
   * @param integralRuleCodes
   * @return 删除结果
   */
  @Override
  @Transactional
  public void deleteByIntegralRuleCode(Set<String> integralRuleCodes) {
    this.integralCalculateRuleRepository.deleteByIntegralRuleCode(integralRuleCodes);
  }

  /**
   * 启用数据
   * @param integralRuleCodes
   * @return 删除结果
   */
  @Override
  @Transactional
  public void enableByIntegralRuleCode(List<String> integralRuleCodes) {
    this.integralCalculateRuleRepository.updateStateByIntegralRuleCode(integralRuleCodes, 1);
  }

  /**
   * 禁用数据
   * @param integralRuleCodes
   * @return 删除结果
   */
  @Override
  @Transactional
  public void disableByIntegralRuleCode(List<String> integralRuleCodes) {
    this.integralCalculateRuleRepository.updateStateByIntegralRuleCode(integralRuleCodes, 0);
  }

  /**
   * 创建验证
   *
   * @param integralCalculateRule
   */
  private void createValidate(IntegralCalculateRule integralCalculateRule) {
    Validate.notNull(integralCalculateRule, "数据操作时，对象信息不能为空！");
    integralCalculateRule.setId(null);
    Validate.notBlank(integralCalculateRule.getIntegralRuleCode(), "数据操作时，积分规则编码不能为空！");
    Validate.notBlank(integralCalculateRule.getIntegralTaskTypeCode(), "数据操作时，积分任务类型编码不能为空！");
    Validate.notBlank(integralCalculateRule.getIntegralTaskTypeName(), "数据操作时，积分任务类型名称不能为空！");
    integralCalculateRule.setTenantCode(TenantUtils.getTenantCode());
  }

  /**
   * 修改验证
   *
   * @param integralCalculateRule
   */
  private void updateValidate(IntegralCalculateRule integralCalculateRule) {
    Validate.notNull(integralCalculateRule, "修改时，对象信息不能为空！");
    Validate.notBlank(integralCalculateRule.getIntegralRuleCode(), "修改数据时，积分规则编码不能为空！");
    Validate.notBlank(integralCalculateRule.getIntegralTaskTypeCode(), "修改数据时，积分任务类型编码不能为空！");
    Validate.notBlank(integralCalculateRule.getIntegralTaskTypeName(), "修改数据时，积分任务类型名称不能为空！");
    integralCalculateRule.setTenantCode(TenantUtils.getTenantCode());
  }
}
