package com.biz.crm.sfa.business.integral.rule.local.service.internal;

import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.position.sdk.service.PositionVoService;
import com.biz.crm.mdm.business.position.sdk.vo.PositionVo;
import com.biz.crm.sfa.business.integral.rule.local.entity.IntegralCalculateRule;
import com.biz.crm.sfa.business.integral.rule.local.entity.IntegralRule;
import com.biz.crm.sfa.business.integral.rule.local.entity.IntegralRuleScope;
import com.biz.crm.sfa.business.integral.rule.local.service.IntegralCalculateRuleService;
import com.biz.crm.sfa.business.integral.rule.local.service.IntegralRuleScopeService;
import com.biz.crm.sfa.business.integral.rule.local.service.IntegralRuleService;
import com.biz.crm.sfa.business.integral.rule.sdk.service.IntegralRuleVoService;
import com.biz.crm.sfa.business.integral.rule.sdk.vo.IntegralCalculateRuleVo;
import com.biz.crm.sfa.business.integral.rule.sdk.vo.IntegralRuleScopeVo;
import com.biz.crm.sfa.business.integral.rule.sdk.vo.IntegralRuleVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @description: 积分规则主表 IntegralRuleVo实现类
 * @author: rentao
 * @date: 2022/6/22 14:57
 */
@Slf4j
@Service
public class IntegralRuleVoServiceImpl implements IntegralRuleVoService {

  @Autowired
  private IntegralRuleService integralRuleService;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;
  @Autowired
  private IntegralCalculateRuleService integralCalculateRuleService;
  @Autowired
  private IntegralRuleScopeService integralRuleScopeService;
  @Autowired
  private LoginUserService loginUserService;
  @Autowired
  private PositionVoService positionVoService;


  /**
   * 通过id查询积分详情
   *
   * @param id
   * @author rentao
   * @date a
   */
  @Override
  public IntegralRuleVo findDetailById(String id) {
    IntegralRule integralRule = this.integralRuleService.findById(id);
    if (Objects.isNull(integralRule)) {
      return null;
    }
    IntegralRuleVo integralRuleVo = this.nebulaToolkitService.copyObjectByBlankList(integralRule, IntegralRuleVo.class, HashSet.class, ArrayList.class);
    //组装明细
    this.assemblyDetail(integralRuleVo);
    return integralRuleVo;
  }

  @Override
  public IntegralRuleVo findDetailByCode(String integralRuleCode) {
    IntegralRule integralRule = this.integralRuleService.findByCode(integralRuleCode);
    if (Objects.isNull(integralRule)) {
      return null;
    }
    IntegralRuleVo integralRuleVo = this.nebulaToolkitService.copyObjectByBlankList(integralRule, IntegralRuleVo.class, HashSet.class, ArrayList.class);
    //组装明细
    this.assemblyDetail(integralRuleVo);
    return integralRuleVo;
  }

  /**
   * 获取当前用户对应的积分计算规则
   *
   * @param
   * @author rentao
   */
  @Override
  public IntegralRuleVo findByLoginUser() {
    FacturerUserDetails loginDetails = this.loginUserService.getLoginDetails(FacturerUserDetails.class);
    String orgCode = loginDetails.getOrgCode();
    String postCode = loginDetails.getPostCode();
    List<PositionVo> positionVos = positionVoService.findByIdsOrCodes(Lists.newLinkedList(), Collections.singletonList(postCode));
    List<String> scopeCodes = new ArrayList<>();
    scopeCodes.add(orgCode);
    if (!CollectionUtils.isEmpty(positionVos)) {
      scopeCodes.add(positionVos.get(0).getPositionLevelCode());
    }
    List<IntegralRuleScope> integralRuleScopes = this.integralRuleScopeService.findByScopeCodes(scopeCodes);
    if (!CollectionUtils.isEmpty(integralRuleScopes) && integralRuleScopes.size() == 1) {
      List<String> integralRuleCodes = integralRuleScopes.stream().filter(integralRuleScope -> integralRuleScope.getState() == 1).map(IntegralRuleScope::getIntegralRuleCode)
          .collect(Collectors.toList());
      if (!CollectionUtils.isEmpty(integralRuleCodes)) {
        return this.findDetailByCode(integralRuleCodes.get(0));
      }
    }
    return null;
  }

  /**
   * 组装数据
   *
   * @param integralRuleVo
   * @author rentao
   * @date a
   */
  private void assemblyDetail(IntegralRuleVo integralRuleVo) {
    String integralRuleCode = integralRuleVo.getIntegralRuleCode();
    List<IntegralCalculateRule> integralCalculateRules = this.integralCalculateRuleService
        .findByIntegralRuleCode(integralRuleCode);
    List<IntegralRuleScope> integralRuleScopes = this.integralRuleScopeService
        .findByIntegralRuleCode(integralRuleCode);
    if (!CollectionUtils.isEmpty(integralCalculateRules)) {
      List<IntegralCalculateRuleVo> list = (List<IntegralCalculateRuleVo>) this.nebulaToolkitService.copyCollectionByBlankList(integralCalculateRules
          , IntegralCalculateRule.class, IntegralCalculateRuleVo.class, HashSet.class, ArrayList.class);
      integralRuleVo.setIntegralCalculateRuleVos(list);
    }
    if (!CollectionUtils.isEmpty(integralRuleScopes)) {
      List<IntegralRuleScopeVo> list = (List<IntegralRuleScopeVo>) this.nebulaToolkitService.copyCollectionByBlankList(integralRuleScopes
          , IntegralRuleScope.class, IntegralRuleScopeVo.class, HashSet.class, ArrayList.class);
      integralRuleVo.setIntegralRuleScopeVos(list);
    }
  }
}
