/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.integral.rule.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.sfa.business.integral.rule.local.entity.IntegralCalculateRule;
import com.biz.crm.sfa.business.integral.rule.local.entity.IntegralRule;
import com.biz.crm.sfa.business.integral.rule.local.entity.IntegralRuleScope;
import com.biz.crm.sfa.business.integral.rule.local.repository.IntegralRuleRepository;
import com.biz.crm.sfa.business.integral.rule.local.service.IntegralCalculateRuleService;
import com.biz.crm.sfa.business.integral.rule.local.service.IntegralRuleScopeService;
import com.biz.crm.sfa.business.integral.rule.local.service.IntegralRuleService;
import com.biz.crm.sfa.business.integral.rule.sdk.dto.IntegralCalculateRuleDto;
import com.biz.crm.sfa.business.integral.rule.sdk.dto.IntegralRuleDto;
import com.biz.crm.sfa.business.integral.rule.sdk.dto.IntegralRuleScopeDto;
import com.biz.crm.sfa.business.integral.rule.sdk.event.IntegralRuleEventListener;
import com.biz.crm.sfa.business.integral.rule.sdk.service.IntegralRuleVoService;
import com.biz.crm.sfa.business.integral.rule.sdk.vo.IntegralRuleVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class IntegralRuleServiceImpl
implements IntegralRuleService {
    @Autowired
    private IntegralRuleRepository integralRuleRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private IntegralRuleVoService integralRuleVoService;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private IntegralCalculateRuleService integralCalculateRuleService;
    @Autowired
    private IntegralRuleScopeService integralRuleScopeService;
    @Autowired(required=false)
    private List<IntegralRuleEventListener> integralRuleEventListeners;

    @Override
    public Page<IntegralRule> findByConditions(Pageable pageable, IntegralRule integralRule) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull((Object)integralRule)) {
            integralRule = new IntegralRule();
        }
        integralRule.setTenantCode(TenantUtils.getTenantCode());
        return this.integralRuleRepository.findByConditions(pageable, integralRule);
    }

    @Override
    public IntegralRule findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (IntegralRule)((Object)this.integralRuleRepository.getById((Serializable)((Object)id)));
    }

    @Override
    public IntegralRule findByCode(String integralCode) {
        if (StringUtils.isBlank((CharSequence)integralCode)) {
            return null;
        }
        return this.integralRuleRepository.findByCode(integralCode);
    }

    @Override
    @Transactional
    public IntegralRule create(IntegralRuleDto integralRuleDto) {
        this.createValidate(integralRuleDto);
        IntegralRule integralRule = this.transformCreate(integralRuleDto);
        List integralRuleScopeDtos = integralRuleDto.getIntegralRuleScopeDtos();
        List integralCalculateRuleDtos = integralRuleDto.getIntegralCalculateRuleDtos();
        List calculateRules = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)integralCalculateRuleDtos, IntegralCalculateRuleDto.class, IntegralCalculateRule.class, HashSet.class, ArrayList.class, new String[0]);
        List integralRuleScopes = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)integralRuleScopeDtos, IntegralRuleScopeDto.class, IntegralRuleScope.class, HashSet.class, ArrayList.class, new String[0]);
        calculateRules.forEach(integralCalculateRule -> integralCalculateRule.setIntegralRuleCode(integralRule.getIntegralRuleCode()));
        integralRuleScopes.forEach(integralRuleScope -> integralRuleScope.setIntegralRuleCode(integralRule.getIntegralRuleCode()));
        this.integralCalculateRuleService.createBatch(calculateRules);
        this.integralRuleScopeService.createBatch(integralRuleScopes);
        this.integralRuleRepository.saveOrUpdate((Object)integralRule);
        if (!CollectionUtils.isEmpty(this.integralRuleEventListeners)) {
            IntegralRuleVo integralRuleVo = (IntegralRuleVo)this.nebulaToolkitService.copyObjectByBlankList((Object)integralRuleDto, IntegralRuleVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.integralRuleEventListeners.forEach(eventListener -> eventListener.onCreate(integralRuleVo));
        }
        return integralRule;
    }

    @Override
    @Transactional
    public IntegralRule update(IntegralRuleDto integralRuleDto) {
        this.updateValidate(integralRuleDto);
        IntegralRuleVo integralRuleVoOld = this.integralRuleVoService.findDetailById(integralRuleDto.getId());
        Validate.notNull((Object)integralRuleVoOld, (String)"\u7f16\u8f91\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        IntegralRule integralRule = this.transformUpdate(integralRuleDto);
        List integralRuleScopeDtos = integralRuleDto.getIntegralRuleScopeDtos();
        List integralCalculateRuleDtos = integralRuleDto.getIntegralCalculateRuleDtos();
        List calculateRules = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)integralCalculateRuleDtos, IntegralCalculateRuleDto.class, IntegralCalculateRule.class, HashSet.class, ArrayList.class, new String[0]);
        List integralRuleScopes = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)integralRuleScopeDtos, IntegralRuleScopeDto.class, IntegralRuleScope.class, HashSet.class, ArrayList.class, new String[0]);
        calculateRules.forEach(integralCalculateRule -> integralCalculateRule.setIntegralRuleCode(integralRuleVoOld.getIntegralRuleCode()));
        integralRuleScopes.forEach(integralRuleScope -> integralRuleScope.setIntegralRuleCode(integralRuleVoOld.getIntegralRuleCode()));
        this.integralCalculateRuleService.updateBatch(calculateRules);
        this.integralRuleScopeService.updateBatch(integralRuleScopes);
        this.integralRuleRepository.updateById((Object)integralRule);
        if (!CollectionUtils.isEmpty(this.integralRuleEventListeners)) {
            IntegralRuleVo integralRuleVo = (IntegralRuleVo)this.nebulaToolkitService.copyObjectByBlankList((Object)integralRuleDto, IntegralRuleVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.integralRuleEventListeners.forEach(eventListener -> eventListener.onUpdate(integralRuleVoOld, integralRuleVo));
        }
        return integralRule;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<IntegralRule> integralRules = this.integralRuleRepository.findByIds(idList);
        this.integralRuleRepository.removeByIds(idList);
        if (!CollectionUtils.isEmpty(integralRules)) {
            Set<String> integralRuleCodes = integralRules.stream().map(IntegralRule::getIntegralRuleCode).distinct().collect(Collectors.toSet());
            this.integralCalculateRuleService.deleteByIntegralRuleCode(integralRuleCodes);
            this.integralRuleScopeService.deleteByIntegralRuleCode(integralRuleCodes);
        }
    }

    @Override
    @Transactional
    public void enable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.integralRuleRepository.updateEnableStatusByIds(idList, EnableStatusEnum.ENABLE);
        List<IntegralRule> integralRules = this.integralRuleRepository.findByIds(idList);
        if (!CollectionUtils.isEmpty(integralRules)) {
            List<String> integralRuleCodes = integralRules.stream().map(IntegralRule::getIntegralRuleCode).distinct().collect(Collectors.toList());
            this.integralCalculateRuleService.enableByIntegralRuleCode(integralRuleCodes);
            this.integralRuleScopeService.enableByIntegralRuleCode(integralRuleCodes);
        }
    }

    @Override
    @Transactional
    public void disable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.integralRuleRepository.updateEnableStatusByIds(idList, EnableStatusEnum.DISABLE);
        List<IntegralRule> integralRules = this.integralRuleRepository.findByIds(idList);
        if (!CollectionUtils.isEmpty(integralRules)) {
            List<String> integralRuleCodes = integralRules.stream().map(IntegralRule::getIntegralRuleCode).distinct().collect(Collectors.toList());
            this.integralCalculateRuleService.disableByIntegralRuleCode(integralRuleCodes);
            this.integralRuleScopeService.disableByIntegralRuleCode(integralRuleCodes);
        }
    }

    private void createValidate(IntegralRuleDto integralRuleDto) {
        Validate.notNull((Object)integralRuleDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        integralRuleDto.setId(null);
        Validate.notBlank((CharSequence)integralRuleDto.getIntegralRuleName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79ef\u5206\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)integralRuleDto.getStartTime(), (String)"\u6570\u636e\u64cd\u4f5c\u65f6\uff0c\u79ef\u5206\u89c4\u5219\u5f00\u59cb\u65f6\u95f4\uff08\u5305\u62ec\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)integralRuleDto.getEndTime(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79ef\u5206\u89c4\u5219\u7ed3\u675f\u65f6\u95f4\uff08\u5305\u62ec\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((integralRuleDto.getStartTime().compareTo(integralRuleDto.getEndTime()) <= 0 ? 1 : 0) != 0, (String)"\u79ef\u5206\u89c4\u5219\u5f00\u59cb\u65f6\u95f4\u5e94\u65e9\u4e8e\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)integralRuleDto.getIntegralCalculateRuleDtos()) ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79ef\u5206\u89c4\u5219\u8ba1\u7b97\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)integralRuleDto.getIntegralRuleScopeDtos()) ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79ef\u5206\u89c4\u5219\u9002\u7528\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.checkOrgAndRole(integralRuleDto.getIntegralRuleScopeDtos(), null);
    }

    private void updateValidate(IntegralRuleDto integralRuleDto) {
        Validate.notNull((Object)integralRuleDto, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)integralRuleDto.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)integralRuleDto.getIntegralRuleCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79ef\u5206\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)integralRuleDto.getIntegralRuleName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79ef\u5206\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)integralRuleDto.getStartTime(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79ef\u5206\u89c4\u5219\u5f00\u59cb\u65f6\u95f4\uff08\u5305\u62ec\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)integralRuleDto.getEndTime(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79ef\u5206\u89c4\u5219\u7ed3\u675f\u65f6\u95f4\uff08\u5305\u62ec\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((integralRuleDto.getStartTime().compareTo(integralRuleDto.getEndTime()) <= 0 ? 1 : 0) != 0, (String)"\u79ef\u5206\u89c4\u5219\u5f00\u59cb\u65f6\u95f4\u5e94\u65e9\u4e8e\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)integralRuleDto.getIntegralCalculateRuleDtos()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79ef\u5206\u89c4\u5219\u8ba1\u7b97\u516c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)integralRuleDto.getIntegralRuleScopeDtos()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79ef\u5206\u89c4\u5219\u9002\u7528\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.checkOrgAndRole(integralRuleDto.getIntegralRuleScopeDtos(), integralRuleDto.getIntegralRuleCode());
    }

    private IntegralRule transformCreate(IntegralRuleDto integralRuleDto) {
        IntegralRule entity = (IntegralRule)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)integralRuleDto, IntegralRule.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setIntegralRuleCode((String)this.generateCodeService.generateCode("JFGZ", 1).get(0));
        entity.setTenantCode(TenantUtils.getTenantCode());
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        integralRuleDto.setIntegralRuleCode(entity.getIntegralRuleCode());
        return entity;
    }

    private IntegralRule transformUpdate(IntegralRuleDto integralRuleDto) {
        IntegralRule entity = (IntegralRule)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)integralRuleDto, IntegralRule.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setTenantCode(TenantUtils.getTenantCode());
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        integralRuleDto.setIntegralRuleCode(entity.getIntegralRuleCode());
        return entity;
    }

    private void checkOrgAndRole(List<IntegralRuleScopeDto> integralRuleScopeDtos, String integralRuleCode) {
        List<String> scopeCodes = integralRuleScopeDtos.stream().map(IntegralRuleScopeDto::getScopeCode).collect(Collectors.toList());
        List<IntegralRuleScope> integralRuleScopes = this.integralRuleScopeService.findByScopeCodes(scopeCodes);
        if (StringUtils.isNotBlank((CharSequence)integralRuleCode) && !CollectionUtils.isEmpty(integralRuleScopes)) {
            integralRuleScopes.removeIf(integralRuleScope -> integralRuleCode.equals(integralRuleScope.getIntegralRuleCode()));
        }
        if (CollectionUtils.isEmpty(integralRuleScopes)) {
            return;
        }
        integralRuleScopeDtos.forEach(integralRuleScopeDto -> {
            List scopeList = integralRuleScopes.stream().filter(integralRuleScope -> integralRuleScope.getScopeType().equals(integralRuleScopeDto.getScopeType()) && integralRuleScope.getScopeCode().equals(integralRuleScopeDto.getScopeCode())).collect(Collectors.toList());
            Validate.isTrue((boolean)CollectionUtils.isEmpty(scopeList), (String)"\u672c\u6b21\u63d0\u5b58\u5728\u91cd\u590d\u6570\u636e\uff01", (Object[])new Object[0]);
        });
    }
}

