/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sfa.business.integral.rule.local.service.internal;

import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.position.sdk.service.PositionVoService;
import com.biz.crm.mdm.business.position.sdk.vo.PositionVo;
import com.biz.crm.sfa.business.integral.rule.local.entity.IntegralCalculateRule;
import com.biz.crm.sfa.business.integral.rule.local.entity.IntegralRule;
import com.biz.crm.sfa.business.integral.rule.local.entity.IntegralRuleScope;
import com.biz.crm.sfa.business.integral.rule.local.service.IntegralCalculateRuleService;
import com.biz.crm.sfa.business.integral.rule.local.service.IntegralRuleScopeService;
import com.biz.crm.sfa.business.integral.rule.local.service.IntegralRuleService;
import com.biz.crm.sfa.business.integral.rule.sdk.service.IntegralRuleVoService;
import com.biz.crm.sfa.business.integral.rule.sdk.vo.IntegralCalculateRuleVo;
import com.biz.crm.sfa.business.integral.rule.sdk.vo.IntegralRuleScopeVo;
import com.biz.crm.sfa.business.integral.rule.sdk.vo.IntegralRuleVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class IntegralRuleVoServiceImpl
implements IntegralRuleVoService {
    private static final Logger log = LoggerFactory.getLogger(IntegralRuleVoServiceImpl.class);
    @Autowired
    private IntegralRuleService integralRuleService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private IntegralCalculateRuleService integralCalculateRuleService;
    @Autowired
    private IntegralRuleScopeService integralRuleScopeService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private PositionVoService positionVoService;

    public IntegralRuleVo findDetailById(String id) {
        IntegralRule integralRule = this.integralRuleService.findById(id);
        if (Objects.isNull((Object)integralRule)) {
            return null;
        }
        IntegralRuleVo integralRuleVo = (IntegralRuleVo)this.nebulaToolkitService.copyObjectByBlankList((Object)integralRule, IntegralRuleVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.assemblyDetail(integralRuleVo);
        return integralRuleVo;
    }

    public IntegralRuleVo findDetailByCode(String integralRuleCode) {
        IntegralRule integralRule = this.integralRuleService.findByCode(integralRuleCode);
        if (Objects.isNull((Object)integralRule)) {
            return null;
        }
        IntegralRuleVo integralRuleVo = (IntegralRuleVo)this.nebulaToolkitService.copyObjectByBlankList((Object)integralRule, IntegralRuleVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.assemblyDetail(integralRuleVo);
        return integralRuleVo;
    }

    public IntegralRuleVo findByLoginUser() {
        List integralRuleCodes;
        List<IntegralRuleScope> integralRuleScopes;
        FacturerUserDetails loginDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
        String orgCode = loginDetails.getOrgCode();
        String postCode = loginDetails.getPostCode();
        List positionVos = this.positionVoService.findByIdsOrCodes((List)Lists.newLinkedList(), Collections.singletonList(postCode));
        ArrayList<String> scopeCodes = new ArrayList<String>();
        scopeCodes.add(orgCode);
        if (!CollectionUtils.isEmpty((Collection)positionVos)) {
            scopeCodes.add(((PositionVo)positionVos.get(0)).getPositionLevelCode());
        }
        if (!CollectionUtils.isEmpty(integralRuleScopes = this.integralRuleScopeService.findByScopeCodes(scopeCodes)) && integralRuleScopes.size() == 1 && !CollectionUtils.isEmpty(integralRuleCodes = integralRuleScopes.stream().filter(integralRuleScope -> integralRuleScope.getState() == 1).map(IntegralRuleScope::getIntegralRuleCode).collect(Collectors.toList()))) {
            return this.findDetailByCode((String)integralRuleCodes.get(0));
        }
        return null;
    }

    private void assemblyDetail(IntegralRuleVo integralRuleVo) {
        List list;
        String integralRuleCode = integralRuleVo.getIntegralRuleCode();
        List<IntegralCalculateRule> integralCalculateRules = this.integralCalculateRuleService.findByIntegralRuleCode(integralRuleCode);
        List<IntegralRuleScope> integralRuleScopes = this.integralRuleScopeService.findByIntegralRuleCode(integralRuleCode);
        if (!CollectionUtils.isEmpty(integralCalculateRules)) {
            list = (List)this.nebulaToolkitService.copyCollectionByBlankList(integralCalculateRules, IntegralCalculateRule.class, IntegralCalculateRuleVo.class, HashSet.class, ArrayList.class, new String[0]);
            integralRuleVo.setIntegralCalculateRuleVos(list);
        }
        if (!CollectionUtils.isEmpty(integralRuleScopes)) {
            list = (List)this.nebulaToolkitService.copyCollectionByBlankList(integralRuleScopes, IntegralRuleScope.class, IntegralRuleScopeVo.class, HashSet.class, ArrayList.class, new String[0]);
            integralRuleVo.setIntegralRuleScopeVos(list);
        }
    }
}

