package com.biz.crm.sfa.business.integral.rule.sdk.enums;

import java.util.Arrays;
import java.util.Objects;
import lombok.Data;

/**
 * @description: 积分规则范围类型
 * @author: rentao
 * @date: 2022/6/24 11:05
 */
public enum IntegralRuleScopeEnum {
  POS_LEVEL("pos", "pos", "职位等级类型", "1"),
  ORG("org", "org", "组织类型", "2");

  private String key;
  /** 字典编码 */
  private String dictCode;
  /** 字典值 */
  private String value;
  /** 字典排序 */
  private String order;

  IntegralRuleScopeEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  public String getKey() {
    return key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public String getValue() {
    return value;
  }

  public String getOrder() {
    return order;
  }

  /**
   * 通过key获取 IntegralRuleScopeEnum
   *
   * @param key
   * @return
   */
  public static IntegralRuleScopeEnum getByKey(String key) {
    return Arrays.stream(IntegralRuleScopeEnum.values())
        .filter(item -> Objects.equals(item.getKey(), key))
        .findFirst()
        .orElse(null);
  }

  /**
   * 通过dictCode获取 ClientTypeEnum
   *
   * @param dictCode
   * @return
   */
  public static IntegralRuleScopeEnum getByDictCode(String dictCode) {
    return Arrays.stream(IntegralRuleScopeEnum.values())
        .filter(item -> Objects.equals(item.getKey(), dictCode))
        .findFirst()
        .orElse(null);
  }
}
