package com.biz.crm.sfa.business.integral.rule.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @description: 积分计算规则Vo
 * @author: rentao
 * @date: 2022/6/24 10:07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "IntegralCalculateRuleVo", description = "积分计算规则Vo")
public class IntegralCalculateRuleVo extends TenantOpVo {

  /**
   * 积分规则编码
   */
  @ApiModelProperty("积分规则编码")
  private String integralRuleCode;

  /**
   * 积分任务类型编码
   */
  @ApiModelProperty("积分任务类型编码")
  private String integralTaskTypeCode;

  /**
   * 积分任务类型名称
   */
  @ApiModelProperty("积分任务类型名称")
  private String integralTaskTypeName;

  /**
   * 积分任务加积分数-任务完成奖励
   */
  @ApiModelProperty("积分任务加积分数")
  private Integer integralTaskReward;

  /**
   * 设定状态：0：禁用/废弃；1：正常
   */
  @ApiModelProperty(name="state" , value = "设定状态：0：禁用/废弃；1：正常")
  private Integer state = 1;
}
