package com.biz.crm.sfa.business.integral.rule.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @description: 积分规则范围Vo
 * @author: rentao
 * @date: 2022/6/24 10:07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "IntegralRuleScopeVo", description = "积分规则范围Vo")
public class IntegralRuleScopeVo extends TenantOpVo {

  /**
   * 积分规则编码
   */
  @ApiModelProperty("积分规则编码")
  private String integralRuleCode;

  /**
   * 被选定的业务类型
   */
  @ApiModelProperty("被选定的业务类型")
  private String scopeType;

  /**
   * 设定状态：0：禁用/废弃；1：正常
   */
  @ApiModelProperty(name="state" , value = "设定状态：0：禁用/废弃；1：正常")
  private Integer state = 1;

  /**
   * 被选定的业务编号
   */
  @ApiModelProperty("被选定的业务编号")
  private String scopeCode;

  /**
   * 被选定的业务名称
   */
  @ApiModelProperty("被选定的业务名称")
  private String scopeName;
}
